/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.Java7SslParametersUtils;
import io.netty.handler.ssl.Java8SslUtils;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine$1;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine$HandshakeState;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine$OpenSslSession;
import io.netty.handler.ssl.SslUtils;
import io.netty.internal.tcnative.Buffer;
import io.netty.internal.tcnative.SSL;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

public class ReferenceCountedOpenSslEngine
extends SSLEngine
implements ApplicationProtocolAccessor,
ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslEngine.class);
    private static final SSLException BEGIN_HANDSHAKE_ENGINE_CLOSED = ThrowableUtil.unknownStackTrace(new SSLException("engine closed"), ReferenceCountedOpenSslEngine.class, "beginHandshake()");
    private static final SSLException HANDSHAKE_ENGINE_CLOSED = ThrowableUtil.unknownStackTrace(new SSLException("engine closed"), ReferenceCountedOpenSslEngine.class, "handshake()");
    private static final SSLException RENEGOTIATION_UNSUPPORTED = ThrowableUtil.unknownStackTrace(new SSLException("renegotiation unsupported"), ReferenceCountedOpenSslEngine.class, "beginHandshake()");
    private static final ResourceLeakDetector<ReferenceCountedOpenSslEngine> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslEngine.class);
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV2 = 0;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV3 = 1;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1 = 2;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_1 = 3;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_2 = 4;
    private static final int[] OPENSSL_OP_NO_PROTOCOLS = new int[]{SSL.SSL_OP_NO_SSLv2, SSL.SSL_OP_NO_SSLv3, SSL.SSL_OP_NO_TLSv1, SSL.SSL_OP_NO_TLSv1_1, SSL.SSL_OP_NO_TLSv1_2};
    private static final int DEFAULT_HOSTNAME_VALIDATION_FLAGS = 0;
    static final int MAX_PLAINTEXT_LENGTH = SSL.SSL_MAX_PLAINTEXT_LENGTH;
    private static final int MAX_RECORD_SIZE = SSL.SSL_MAX_RECORD_LENGTH;
    private static final AtomicIntegerFieldUpdater<ReferenceCountedOpenSslEngine> DESTROYED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ReferenceCountedOpenSslEngine.class, "destroyed");
    private static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private long ssl;
    private long networkBIO;
    private boolean certificateSet;
    private ReferenceCountedOpenSslEngine$HandshakeState handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile int destroyed;
    private volatile String applicationProtocol;
    private final ResourceLeakTracker<ReferenceCountedOpenSslEngine> leak;
    private final AbstractReferenceCounted refCnt = new ReferenceCountedOpenSslEngine$1(this);
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private volatile long lastAccessed = -1L;
    private String endPointIdentificationAlgorithm;
    private Object algorithmConstraints;
    private List<String> sniHostNames;
    private volatile Collection<?> matchers;
    private boolean isInboundDone;
    private boolean outboundClosed;
    final boolean jdkCompatibilityMode;
    private final boolean clientMode;
    private final ByteBufAllocator alloc;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final ReferenceCountedOpenSslEngine$OpenSslSession session;
    private final Certificate[] localCerts;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final OpenSslKeyMaterialManager keyMaterialManager;
    private final boolean enableOcsp;
    private int maxWrapOverhead;
    private int maxWrapBufferSize;
    SSLHandshakeException handshakeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslEngine(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2, boolean bl3) {
        super(string, n2);
        long l2;
        OpenSsl.ensureAvailability();
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)referenceCountedOpenSslContext.applicationProtocolNegotiator();
        this.session = new ReferenceCountedOpenSslEngine$OpenSslSession(this, referenceCountedOpenSslContext.sessionContext());
        this.clientMode = referenceCountedOpenSslContext.isClient();
        this.engineMap = referenceCountedOpenSslContext.engineMap;
        this.localCerts = referenceCountedOpenSslContext.keyCertChain;
        this.keyMaterialManager = referenceCountedOpenSslContext.keyMaterialManager();
        this.enableOcsp = referenceCountedOpenSslContext.enableOcsp;
        this.jdkCompatibilityMode = bl2;
        Lock lock = referenceCountedOpenSslContext.ctxLock.readLock();
        lock.lock();
        try {
            l2 = SSL.newSSL((long)referenceCountedOpenSslContext.ctx, (!referenceCountedOpenSslContext.isClient() ? 1 : 0) != 0);
        }
        finally {
            lock.unlock();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            this.ssl = l2;
            try {
                this.networkBIO = SSL.bioNewByteBuffer((long)this.ssl, (int)referenceCountedOpenSslContext.getBioNonApplicationBufferSize());
                this.setClientAuth(this.clientMode ? ClientAuth.NONE : referenceCountedOpenSslContext.clientAuth);
                if (referenceCountedOpenSslContext.protocols != null) {
                    this.setEnabledProtocols(referenceCountedOpenSslContext.protocols);
                }
                if (this.clientMode && string != null) {
                    SSL.setTlsExtHostName((long)this.ssl, (String)string);
                }
                if (this.enableOcsp) {
                    SSL.enableOcsp((long)this.ssl);
                }
                if (!bl2) {
                    SSL.setMode((long)this.ssl, (int)(SSL.getMode((long)this.ssl) | SSL.SSL_MODE_ENABLE_PARTIAL_WRITE));
                }
                this.calculateMaxWrapOverhead();
            }
            catch (Throwable throwable) {
                SSL.freeSSL((long)this.ssl);
                PlatformDependent.throwException(throwable);
            }
        }
        this.leak = bl3 ? leakDetector.track(this) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOcspResponse(byte[] byArray) {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (this.clientMode) {
            throw new IllegalStateException("Not a server SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            SSL.setOcspResponse((long)this.ssl, (byte[])byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getOcspResponse() {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (!this.clientMode) {
            throw new IllegalStateException("Not a client SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            return SSL.getOcspResponse((long)this.ssl);
        }
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted retain(int n2) {
        this.refCnt.retain(n2);
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public final boolean release(int n2) {
        return this.refCnt.release(n2);
    }

    @Override
    public final synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public final synchronized long sslPointer() {
        return this.ssl;
    }

    public final synchronized void shutdown() {
        if (DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            this.engineMap.remove(this.ssl);
            SSL.freeSSL((long)this.ssl);
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.outboundClosed = true;
            this.isInboundDone = true;
        }
        SSL.clearError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer byteBuffer, int n2) {
        int n3;
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n3 = SSL.writeToSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n4), (int)n2);
            if (n3 > 0) {
                byteBuffer.position(n4 + n3);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                byteBuffer.limit(n4 + n2);
                byteBuf.setBytes(0, byteBuffer);
                byteBuffer.limit(n5);
                n3 = SSL.writeToSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n2);
                if (n3 > 0) {
                    byteBuffer.position(n4 + n3);
                } else {
                    byteBuffer.position(n4);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n3;
    }

    private ByteBuf writeEncryptedData(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n3), (int)n2, (boolean)false);
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                int n4 = byteBuffer.limit();
                byteBuffer.limit(n3 + n2);
                byteBuf.writeBytes(byteBuffer);
                byteBuffer.position(n3);
                byteBuffer.limit(n4);
                SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(byteBuf), (int)n2, (boolean)false);
                return byteBuf;
            }
            catch (Throwable throwable) {
                byteBuf.release();
                PlatformDependent.throwException(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer byteBuffer) {
        int n2;
        int n3 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            n2 = SSL.readFromSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n3), (int)(byteBuffer.limit() - n3));
            if (n2 > 0) {
                byteBuffer.position(n3 + n2);
            }
        } else {
            int n4 = byteBuffer.limit();
            int n5 = Math.min(this.maxEncryptedPacketLength0(), n4 - n3);
            ByteBuf byteBuf = this.alloc.directBuffer(n5);
            try {
                n2 = SSL.readFromSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n5);
                if (n2 > 0) {
                    byteBuffer.limit(n3 + n2);
                    byteBuf.getBytes(byteBuf.readerIndex(), byteBuffer);
                    byteBuffer.limit(n4);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n2;
    }

    final synchronized int maxWrapOverhead() {
        return this.maxWrapOverhead;
    }

    final synchronized int maxEncryptedPacketLength() {
        return this.maxEncryptedPacketLength0();
    }

    final int maxEncryptedPacketLength0() {
        return this.maxWrapOverhead + MAX_PLAINTEXT_LENGTH;
    }

    final int calculateMaxLengthForWrap(int n2, int n3) {
        return (int)Math.min((long)this.maxWrapBufferSize, (long)n2 + (long)this.maxWrapOverhead * (long)n3);
    }

    final synchronized int sslPending() {
        return this.sslPending0();
    }

    private void calculateMaxWrapOverhead() {
        this.maxWrapOverhead = SSL.getMaxWrapOverhead((long)this.ssl);
        this.maxWrapBufferSize = this.jdkCompatibilityMode ? this.maxEncryptedPacketLength0() : this.maxEncryptedPacketLength0() << 4;
    }

    private int sslPending0() {
        return this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED ? 0 : SSL.sslPending((long)this.ssl);
    }

    private boolean isBytesAvailableEnoughForWrap(int n2, int n3, int n4) {
        return (long)n2 - (long)this.maxWrapOverhead * (long)n4 >= (long)n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n2, int n3, ByteBuffer byteBuffer) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("srcs is null");
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (n2 >= byteBufferArray.length || n2 + n3 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n2 + ", length: " + n3 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isOutboundDone()) {
                return this.isInboundDone() || this.isDestroyed() ? CLOSED_NOT_HANDSHAKING : NEED_UNWRAP_CLOSED;
            }
            int n4 = 0;
            ByteBuf byteBuf = null;
            try {
                int n5;
                if (byteBuffer.isDirect()) {
                    SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)byteBuffer.position()), (int)byteBuffer.remaining(), (boolean)true);
                } else {
                    byteBuf = this.alloc.directBuffer(byteBuffer.remaining());
                    SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(byteBuf), (int)byteBuf.writableBytes(), (boolean)true);
                }
                int n6 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                if (this.outboundClosed) {
                    n4 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                    if (n4 <= 0) {
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
                        return sSLEngineResult;
                    }
                    if (!this.doSSLShutdown()) {
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, n4);
                        return sSLEngineResult;
                    }
                    n4 = n6 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, n4);
                    return sSLEngineResult;
                }
                SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                    if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY) {
                        this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_IMPLICITLY;
                    }
                    if ((n4 = SSL.bioFlushByteBuffer((long)this.networkBIO)) > 0 && this.handshakeException != null) {
                        SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, n4);
                        return sSLEngineResult;
                    }
                    handshakeStatus = this.handshake();
                    n4 = n6 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                    if (n4 > 0) {
                        SSLEngineResult sSLEngineResult = this.newResult(this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? (n4 == n6 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : this.getHandshakeStatus(SSL.bioLengthNonApplication((long)this.networkBIO))) : SSLEngineResult.HandshakeStatus.FINISHED), 0, n4);
                        return sSLEngineResult;
                    }
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        SSLEngineResult sSLEngineResult = this.isOutboundDone() ? NEED_UNWRAP_CLOSED : NEED_UNWRAP_OK;
                        return sSLEngineResult;
                    }
                    if (this.outboundClosed) {
                        n4 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, 0, n4);
                        return sSLEngineResult;
                    }
                }
                int n7 = n2 + n3;
                if (this.jdkCompatibilityMode) {
                    n5 = 0;
                    for (int i2 = n2; i2 < n7; ++i2) {
                        ByteBuffer byteBuffer2 = byteBufferArray[i2];
                        if (byteBuffer2 == null) {
                            throw new IllegalArgumentException("srcs[" + i2 + "] is null");
                        }
                        if (n5 == MAX_PLAINTEXT_LENGTH || (n5 += byteBuffer2.remaining()) <= MAX_PLAINTEXT_LENGTH && n5 >= 0) continue;
                        n5 = MAX_PLAINTEXT_LENGTH;
                    }
                    if (!this.isBytesAvailableEnoughForWrap(byteBuffer.remaining(), n5, 1)) {
                        SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
                        return sSLEngineResult;
                    }
                }
                n5 = 0;
                n4 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                while (n2 < n7) {
                    ByteBuffer byteBuffer3 = byteBufferArray[n2];
                    int n8 = byteBuffer3.remaining();
                    if (n8 != 0) {
                        int n9;
                        int n10;
                        if (this.jdkCompatibilityMode) {
                            n10 = this.writePlaintextData(byteBuffer3, Math.min(n8, MAX_PLAINTEXT_LENGTH - n5));
                        } else {
                            n9 = byteBuffer.remaining() - n4 - this.maxWrapOverhead;
                            if (n9 <= 0) {
                                SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), n5, n4);
                                return sSLEngineResult;
                            }
                            n10 = this.writePlaintextData(byteBuffer3, Math.min(n8, n9));
                        }
                        if (n10 > 0) {
                            n5 += n10;
                            n9 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                            n6 = n9;
                            if (this.jdkCompatibilityMode || (n4 += n6 - n9) == byteBuffer.remaining()) {
                                SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n5, n4);
                                return sSLEngineResult;
                            }
                        } else {
                            n9 = SSL.getError((long)this.ssl, (int)n10);
                            if (n9 == SSL.SSL_ERROR_ZERO_RETURN) {
                                if (!this.receivedShutdown) {
                                    this.closeAll();
                                    SSLEngineResult.HandshakeStatus handshakeStatus2 = this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? ((n4 += n6 - SSL.bioLengthByteBuffer((long)this.networkBIO)) == byteBuffer.remaining() ? SSLEngineResult.HandshakeStatus.NEED_WRAP : this.getHandshakeStatus(SSL.bioLengthNonApplication((long)this.networkBIO))) : SSLEngineResult.HandshakeStatus.FINISHED);
                                    SSLEngineResult sSLEngineResult = this.newResult(handshakeStatus2, n5, n4);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, n5, n4);
                                return sSLEngineResult;
                            }
                            if (n9 == SSL.SSL_ERROR_WANT_READ) {
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_UNWRAP, n5, n4);
                                return sSLEngineResult;
                            }
                            if (n9 != SSL.SSL_ERROR_WANT_WRITE) {
                                throw this.shutdownWithError("SSL_write");
                            }
                            SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, n5, n4);
                            return sSLEngineResult;
                        }
                    }
                    ++n2;
                }
                SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n5, n4);
                return sSLEngineResult;
            }
            finally {
                SSL.bioClearByteBuffer((long)this.networkBIO);
                if (byteBuf == null) {
                    byteBuffer.position(byteBuffer.position() + n4);
                } else {
                    assert (byteBuf.readableBytes() <= byteBuffer.remaining()) : "The destination buffer " + byteBuffer + " didn't have enough remaining space to hold the encrypted content in " + byteBuf;
                    byteBuffer.put(byteBuf.internalNioBuffer(byteBuf.readerIndex(), n4));
                    byteBuf.release();
                }
            }
        }
    }

    private SSLEngineResult newResult(SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) {
        return this.newResult(SSLEngineResult.Status.OK, handshakeStatus, n2, n3);
    }

    private SSLEngineResult newResult(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) {
        if (this.isOutboundDone()) {
            if (this.isInboundDone()) {
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                this.shutdown();
            }
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, handshakeStatus, n2, n3);
        }
        return new SSLEngineResult(status, handshakeStatus, n2, n3);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) {
        return this.newResult(this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED), n2, n3);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n2, int n3) {
        return this.newResult(status, this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED), n2, n3);
    }

    private SSLException shutdownWithError(String string) {
        String string2 = SSL.getLastError();
        return this.shutdownWithError(string, string2);
    }

    private SSLException shutdownWithError(String string, String string2) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} failed: OpenSSL error: {}", (Object)string, (Object)string2);
        }
        this.shutdown();
        if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return new SSLException(string2);
        }
        return new SSLHandshakeException(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, int n2, int n3, ByteBuffer[] byteBufferArray2, int n4, int n5) {
        Object object;
        int n6;
        ByteBuffer byteBuffer;
        if (byteBufferArray == null) {
            throw new NullPointerException("srcs");
        }
        if (n2 >= byteBufferArray.length || n2 + n3 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n2 + ", length: " + n3 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBufferArray2 == null) {
            throw new IllegalArgumentException("dsts is null");
        }
        if (n4 >= byteBufferArray2.length || n4 + n5 > byteBufferArray2.length) {
            throw new IndexOutOfBoundsException("offset: " + n4 + ", length: " + n5 + " (expected: offset <= offset + length <= dsts.length (" + byteBufferArray2.length + "))");
        }
        long l2 = 0L;
        int n7 = n4 + n5;
        for (n6 = n4; n6 < n7; l2 += (long)byteBuffer.remaining(), ++n6) {
            byteBuffer = byteBufferArray2[n6];
            if (byteBuffer == null) {
                throw new IllegalArgumentException("dsts[" + n6 + "] is null");
            }
            if (!byteBuffer.isReadOnly()) continue;
            throw new ReadOnlyBufferException();
        }
        n6 = n2 + n3;
        long l3 = 0L;
        for (int i2 = n2; i2 < n6; l3 += (long)object.remaining(), ++i2) {
            object = byteBufferArray[i2];
            if (object != null) continue;
            throw new IllegalArgumentException("srcs[" + i2 + "] is null");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            int n8;
            int n9;
            block50: {
                int n10;
                if (this.isInboundDone()) {
                    return this.isOutboundDone() || this.isDestroyed() ? CLOSED_NOT_HANDSHAKING : NEED_WRAP_CLOSED;
                }
                object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                    if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY) {
                        this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_IMPLICITLY;
                    }
                    if ((object = this.handshake()) == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        return NEED_WRAP_OK;
                    }
                    if (this.isInboundDone) {
                        return NEED_WRAP_CLOSED;
                    }
                }
                int n11 = this.sslPending0();
                if (this.jdkCompatibilityMode) {
                    if (l3 < 5L) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    n10 = SslUtils.getEncryptedPacketLength(byteBufferArray, n2);
                    if (n10 == -2) {
                        throw new NotSslRecordException("not an SSL/TLS record");
                    }
                    n9 = n10 - 5;
                    if ((long)n9 > l2) {
                        if (n9 > MAX_RECORD_SIZE) {
                            throw new SSLException("Illegal packet length: " + n9 + " > " + this.session.getApplicationBufferSize());
                        }
                        this.session.tryExpandApplicationBufferSize(n9);
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (l3 < (long)n10) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                } else {
                    if (l3 == 0L && n11 <= 0) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (l2 == 0L) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    n10 = (int)Math.min(Integer.MAX_VALUE, l3);
                }
                assert (n2 < n6);
                assert (l2 > 0L);
                n9 = 0;
                n8 = 0;
                try {
                    while (true) {
                        int n12;
                        ByteBuf byteBuf;
                        ByteBuffer byteBuffer2;
                        int n13;
                        if ((n13 = (byteBuffer2 = byteBufferArray[n2]).remaining()) == 0) {
                            if (n11 <= 0) {
                                if (++n2 < n6) continue;
                                break;
                            }
                            byteBuf = null;
                            n12 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                        } else {
                            n12 = Math.min(n10, n13);
                            byteBuf = this.writeEncryptedData(byteBuffer2, n12);
                        }
                        try {
                            int n14;
                            block51: {
                                while (true) {
                                    ByteBuffer byteBuffer3;
                                    if (!(byteBuffer3 = byteBufferArray2[n4]).hasRemaining()) {
                                        if (++n4 < n7) continue;
                                        break block50;
                                    }
                                    n14 = this.readPlaintextData(byteBuffer3);
                                    int n15 = n12 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                                    n8 += n15;
                                    n10 -= n15;
                                    n12 -= n15;
                                    byteBuffer2.position(byteBuffer2.position() + n15);
                                    if (n14 <= 0) break block51;
                                    n9 += n14;
                                    if (!byteBuffer3.hasRemaining()) {
                                        n11 = this.sslPending0();
                                        if (++n4 < n7) continue;
                                        SSLEngineResult sSLEngineResult = n11 > 0 ? this.newResult(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), n8, n9) : this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n8, n9);
                                        return sSLEngineResult;
                                    }
                                    if (n10 == 0 || this.jdkCompatibilityMode) break;
                                }
                                break;
                            }
                            int n16 = SSL.getError((long)this.ssl, (int)n14);
                            if (n16 != SSL.SSL_ERROR_WANT_READ && n16 != SSL.SSL_ERROR_WANT_WRITE) {
                                if (n16 == SSL.SSL_ERROR_ZERO_RETURN) {
                                    if (!this.receivedShutdown) {
                                        this.closeAll();
                                    }
                                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n8, n9);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.sslReadErrorResult(SSL.getLastErrorNumber(), n8, n9);
                                return sSLEngineResult;
                            }
                            if (++n2 < n6) continue;
                        }
                        finally {
                            if (byteBuf == null) continue;
                            byteBuf.release();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    SSL.bioClearByteBuffer((long)this.networkBIO);
                    this.rejectRemoteInitiatedRenegotiation();
                }
            }
            if (!this.receivedShutdown && (SSL.getShutdown((long)this.ssl) & SSL.SSL_RECEIVED_SHUTDOWN) == SSL.SSL_RECEIVED_SHUTDOWN) {
                this.closeAll();
            }
            return this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n8, n9);
        }
    }

    private SSLEngineResult sslReadErrorResult(int n2, int n3, int n4) {
        String string = SSL.getErrorString((long)n2);
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            if (this.handshakeException == null && this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                this.handshakeException = new SSLHandshakeException(string);
            }
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n3, n4);
        }
        throw this.shutdownWithError("SSL_read", string);
    }

    private void closeAll() {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegotiation() {
        if (!this.isDestroyed() && SSL.getHandshakeCount((long)this.ssl) > 1) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotiation not allowed");
        }
    }

    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
        return this.unwrap(byteBufferArray, 0, byteBufferArray.length, byteBufferArray2, 0, byteBufferArray2.length);
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer byteBuffer) {
        this.singleSrcBuffer[0] = byteBuffer;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer byteBuffer) {
        this.singleDstBuffer[0] = byteBuffer;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n2, int n3) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), 0, 1, byteBufferArray, n2, n3);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            SSLEngineResult sSLEngineResult = this.wrap(this.singleSrcBuffer(byteBuffer), byteBuffer2);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), this.singleDstBuffer(byteBuffer2));
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), byteBufferArray);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    @Override
    public final Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public final synchronized void closeInbound() {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        if (this.isOutboundDone()) {
            this.shutdown();
        }
        if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public final synchronized boolean isInboundDone() {
        return this.isInboundDone;
    }

    @Override
    public final synchronized void closeOutbound() {
        if (this.outboundClosed) {
            return;
        }
        this.outboundClosed = true;
        if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.isDestroyed()) {
            int n2 = SSL.getShutdown((long)this.ssl);
            if ((n2 & SSL.SSL_SENT_SHUTDOWN) != SSL.SSL_SENT_SHUTDOWN) {
                this.doSSLShutdown();
            }
        } else {
            this.shutdown();
        }
    }

    private boolean doSSLShutdown() {
        if (SSL.isInInit((long)this.ssl) != 0) {
            return false;
        }
        int n2 = SSL.shutdownSSL((long)this.ssl);
        if (n2 < 0) {
            int n3 = SSL.getError((long)this.ssl, (int)n2);
            if (n3 == SSL.SSL_ERROR_SYSCALL || n3 == SSL.SSL_ERROR_SSL) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SSL_shutdown failed: OpenSSL error: {}", (Object)SSL.getLastError());
                }
                this.shutdown();
                return false;
            }
            SSL.clearError();
        }
        return true;
    }

    @Override
    public final synchronized boolean isOutboundDone() {
        return this.outboundClosed && (this.networkBIO == 0L || SSL.bioLengthNonApplication((long)this.networkBIO) == 0);
    }

    @Override
    public final String[] getSupportedCipherSuites() {
        return OpenSsl.AVAILABLE_CIPHER_SUITES.toArray(new String[OpenSsl.AVAILABLE_CIPHER_SUITES.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getEnabledCipherSuites() {
        String[] stringArray;
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            stringArray = SSL.getCiphers((long)this.ssl);
        }
        if (stringArray == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = this.toJavaCipherSuite(stringArray[i2]);
                if (string == null) continue;
                stringArray[i2] = string;
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEnabledCipherSuites(String[] stringArray) {
        ObjectUtil.checkNotNull(stringArray, "cipherSuites");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null) break;
            String string2 = CipherSuiteConverter.toOpenSsl(string);
            if (string2 == null) {
                string2 = string;
            }
            if (!OpenSsl.isCipherSuiteAvailable(string2)) {
                throw new IllegalArgumentException("unsupported cipher suite: " + string + '(' + string2 + ')');
            }
            stringBuilder.append(string2);
            stringBuilder.append(':');
        }
        if (stringBuilder.length() == 0) {
            throw new IllegalArgumentException("empty cipher suites");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        String string = stringBuilder.toString();
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (!this.isDestroyed()) {
                try {
                    SSL.setCipherSuites((long)this.ssl, (String)string);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to enable cipher suites: " + string, exception);
                }
            } else {
                throw new IllegalStateException("failed to enable cipher suites: " + string);
            }
        }
    }

    @Override
    public final String[] getSupportedProtocols() {
        return OpenSsl.SUPPORTED_PROTOCOLS_SET.toArray(new String[OpenSsl.SUPPORTED_PROTOCOLS_SET.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getEnabledProtocols() {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>(6);
        arrayList.add("SSLv2Hello");
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return arrayList.toArray(new String[1]);
            }
            n2 = SSL.getOptions((long)this.ssl);
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1, "TLSv1")) {
            arrayList.add("TLSv1");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1_1, "TLSv1.1")) {
            arrayList.add("TLSv1.1");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_TLSv1_2, "TLSv1.2")) {
            arrayList.add("TLSv1.2");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_SSLv2, "SSLv2")) {
            arrayList.add("SSLv2");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n2, SSL.SSL_OP_NO_SSLv3, "SSLv3")) {
            arrayList.add("SSLv3");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static boolean isProtocolEnabled(int n2, int n3, String string) {
        return (n2 & n3) == 0 && OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        int n2 = OPENSSL_OP_NO_PROTOCOLS.length;
        int n3 = 0;
        for (String string : stringArray) {
            if (!OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string)) {
                throw new IllegalArgumentException("Protocol " + string + " is not supported.");
            }
            if (string.equals("SSLv2")) {
                if (n2 > 0) {
                    n2 = 0;
                }
                if (n3 >= 0) continue;
                n3 = 0;
                continue;
            }
            if (string.equals("SSLv3")) {
                if (n2 > 1) {
                    n2 = 1;
                }
                if (n3 >= 1) continue;
                n3 = 1;
                continue;
            }
            if (string.equals("TLSv1")) {
                if (n2 > 2) {
                    n2 = 2;
                }
                if (n3 >= 2) continue;
                n3 = 2;
                continue;
            }
            if (string.equals("TLSv1.1")) {
                if (n2 > 3) {
                    n2 = 3;
                }
                if (n3 >= 3) continue;
                n3 = 3;
                continue;
            }
            if (!string.equals("TLSv1.2")) continue;
            if (n2 > 4) {
                n2 = 4;
            }
            if (n3 >= 4) continue;
            n3 = 4;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            int n4;
            if (!this.isDestroyed()) {
                int n5;
                SSL.clearOptions((long)this.ssl, (int)(SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2));
                n4 = 0;
                for (n5 = 0; n5 < n2; ++n5) {
                    n4 |= OPENSSL_OP_NO_PROTOCOLS[n5];
                }
                assert (n3 != Integer.MAX_VALUE);
                for (n5 = n3 + 1; n5 < OPENSSL_OP_NO_PROTOCOLS.length; ++n5) {
                    n4 |= OPENSSL_OP_NO_PROTOCOLS[n5];
                }
            } else {
                throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(stringArray));
            }
            SSL.setOptions((long)this.ssl, (int)n4);
        }
    }

    @Override
    public final SSLSession getSession() {
        return this.session;
    }

    @Override
    public final synchronized void beginHandshake() {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed(BEGIN_HANDSHAKE_ENGINE_CLOSED);
                this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY;
                this.calculateMaxWrapOverhead();
                break;
            }
            case STARTED_EXPLICITLY: {
                break;
            }
            case FINISHED: {
                throw RENEGOTIATION_UNSUPPORTED;
            }
            case NOT_STARTED: {
                this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY;
                this.handshake();
                this.calculateMaxWrapOverhead();
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void checkEngineClosed(SSLException sSLException) {
        if (this.isDestroyed()) {
            throw sSLException;
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int n2) {
        return n2 > 0 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    private SSLEngineResult.HandshakeStatus handshake() {
        int n2;
        if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed(HANDSHAKE_ENGINE_CLOSED);
        SSLHandshakeException sSLHandshakeException = this.handshakeException;
        if (sSLHandshakeException != null) {
            if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            this.handshakeException = null;
            this.shutdown();
            throw sSLHandshakeException;
        }
        this.engineMap.add(this);
        if (this.lastAccessed == -1L) {
            this.lastAccessed = System.currentTimeMillis();
        }
        if (!this.certificateSet && this.keyMaterialManager != null) {
            this.certificateSet = true;
            this.keyMaterialManager.setKeyMaterial(this);
        }
        if ((n2 = SSL.doHandshake((long)this.ssl)) <= 0) {
            if (this.handshakeException != null) {
                sSLHandshakeException = this.handshakeException;
                this.handshakeException = null;
                this.shutdown();
                throw sSLHandshakeException;
            }
            int n3 = SSL.getError((long)this.ssl, (int)n2);
            if (n3 == SSL.SSL_ERROR_WANT_READ || n3 == SSL.SSL_ERROR_WANT_WRITE) {
                return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
            }
            throw this.shutdownWithError("SSL_do_handshake");
        }
        this.session.handshakeFinished();
        this.engineMap.remove(this.ssl);
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return this.handshake();
        }
        return handshakeStatus;
    }

    @Override
    public final synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.needPendingStatus() ? ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO)) : SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int n2) {
        return this.needPendingStatus() ? ReferenceCountedOpenSslEngine.pendingStatus(n2) : SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.isDestroyed() && (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED || this.isInboundDone() || this.isOutboundDone());
    }

    private String toJavaCipherSuite(String string) {
        if (string == null) {
            return null;
        }
        String string2 = ReferenceCountedOpenSslEngine.toJavaCipherSuitePrefix(SSL.getVersion((long)this.ssl));
        return CipherSuiteConverter.toJava(string, string2);
    }

    private static String toJavaCipherSuitePrefix(String string) {
        int n2 = string == null || string.isEmpty() ? 0 : (int)string.charAt(0);
        switch (n2) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public final void setUseClientMode(boolean bl2) {
        if (bl2 != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public final void setNeedClientAuth(boolean bl2) {
        this.setClientAuth(bl2 ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    @Override
    public final boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    @Override
    public final void setWantClientAuth(boolean bl2) {
        this.setClientAuth(bl2 ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    @Override
    public final boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    public final synchronized void setVerify(int n2, int n3) {
        SSL.setVerify((long)this.ssl, (int)n2, (int)n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuth clientAuth) {
        if (this.clientMode) {
            return;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.clientAuth == clientAuth) {
                return;
            }
            switch (clientAuth) {
                case NONE: {
                    SSL.setVerify((long)this.ssl, (int)0, (int)10);
                    break;
                }
                case REQUIRE: {
                    SSL.setVerify((long)this.ssl, (int)2, (int)10);
                    break;
                }
                case OPTIONAL: {
                    SSL.setVerify((long)this.ssl, (int)1, (int)10);
                    break;
                }
                default: {
                    throw new Error(clientAuth.toString());
                }
            }
            this.clientAuth = clientAuth;
        }
    }

    @Override
    public final void setEnableSessionCreation(boolean bl2) {
        if (bl2) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    public final synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        int n2 = PlatformDependent.javaVersion();
        if (n2 >= 7) {
            sSLParameters.setEndpointIdentificationAlgorithm(this.endPointIdentificationAlgorithm);
            Java7SslParametersUtils.setAlgorithmConstraints(sSLParameters, this.algorithmConstraints);
            if (n2 >= 8) {
                if (this.sniHostNames != null) {
                    Java8SslUtils.setSniHostNames(sSLParameters, this.sniHostNames);
                }
                if (!this.isDestroyed()) {
                    Java8SslUtils.setUseCipherSuitesOrder(sSLParameters, (SSL.getOptions((long)this.ssl) & SSL.SSL_OP_CIPHER_SERVER_PREFERENCE) != 0);
                }
                Java8SslUtils.setSNIMatchers(sSLParameters, this.matchers);
            }
        }
        return sSLParameters;
    }

    @Override
    public final synchronized void setSSLParameters(SSLParameters sSLParameters) {
        int n2 = PlatformDependent.javaVersion();
        if (n2 >= 7) {
            Object object;
            if (sSLParameters.getAlgorithmConstraints() != null) {
                throw new IllegalArgumentException("AlgorithmConstraints are not supported.");
            }
            if (n2 >= 8) {
                if (!this.isDestroyed()) {
                    if (this.clientMode) {
                        object = Java8SslUtils.getSniHostNames(sSLParameters);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            SSL.setTlsExtHostName((long)this.ssl, (String)string);
                        }
                        this.sniHostNames = object;
                    }
                    if (Java8SslUtils.getUseCipherSuitesOrder(sSLParameters)) {
                        SSL.setOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    } else {
                        SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    }
                }
                this.matchers = sSLParameters.getSNIMatchers();
            }
            boolean bl2 = (object = sSLParameters.getEndpointIdentificationAlgorithm()) != null && !((String)object).isEmpty();
            SSL.setHostNameValidation((long)this.ssl, (int)0, (String)(bl2 ? this.getPeerHost() : null));
            if (this.clientMode && bl2) {
                SSL.setVerify((long)this.ssl, (int)2, (int)-1);
            }
            this.endPointIdentificationAlgorithm = object;
            this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
        }
        super.setSSLParameters(sSLParameters);
    }

    private boolean isDestroyed() {
        return this.destroyed != 0;
    }

    final boolean checkSniHostnameMatch(String string) {
        return Java8SslUtils.checkSniHostnameMatch(this.matchers, string);
    }

    @Override
    public String getNegotiatedApplicationProtocol() {
        return this.applicationProtocol;
    }

    private static long bufferAddress(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.directBufferAddress(byteBuffer);
        }
        return Buffer.address((ByteBuffer)byteBuffer);
    }

    static /* synthetic */ ResourceLeakTracker access$000(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.leak;
    }

    static /* synthetic */ boolean access$100(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.isDestroyed();
    }

    static /* synthetic */ long access$200(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.ssl;
    }

    static /* synthetic */ long access$300(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.lastAccessed;
    }

    static /* synthetic */ String access$400(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        return referenceCountedOpenSslEngine.toJavaCipherSuite(string);
    }

    static /* synthetic */ void access$500(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        referenceCountedOpenSslEngine.calculateMaxWrapOverhead();
    }

    static /* synthetic */ ReferenceCountedOpenSslEngine$HandshakeState access$602(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, ReferenceCountedOpenSslEngine$HandshakeState referenceCountedOpenSslEngine$HandshakeState) {
        referenceCountedOpenSslEngine.handshakeState = referenceCountedOpenSslEngine$HandshakeState;
        return referenceCountedOpenSslEngine.handshakeState;
    }

    static /* synthetic */ boolean access$700(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.clientMode;
    }

    static /* synthetic */ boolean access$800(Object[] objectArray) {
        return ReferenceCountedOpenSslEngine.isEmpty(objectArray);
    }

    static /* synthetic */ boolean access$900(byte[] byArray) {
        return ReferenceCountedOpenSslEngine.isEmpty(byArray);
    }

    static /* synthetic */ OpenSslApplicationProtocolNegotiator access$1000(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.apn;
    }

    static /* synthetic */ String access$1102(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        referenceCountedOpenSslEngine.applicationProtocol = string;
        return referenceCountedOpenSslEngine.applicationProtocol;
    }

    static /* synthetic */ Certificate[] access$1200(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.localCerts;
    }

    static /* synthetic */ int access$1300() {
        return MAX_RECORD_SIZE;
    }
}

