/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig$SelectedListenerFailureBehavior;
import io.netty.handler.ssl.OpenSslJavaxX509Certificate;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslX509Certificate;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine$HandshakeState;
import io.netty.internal.tcnative.SSL;
import io.netty.util.internal.EmptyArrays;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

final class ReferenceCountedOpenSslEngine$OpenSslSession
implements SSLSession {
    private final OpenSslSessionContext sessionContext;
    private X509Certificate[] x509PeerCerts;
    private Certificate[] peerCerts;
    private String protocol;
    private String cipher;
    private byte[] id;
    private long creationTime;
    private volatile int applicationBufferSize = ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH;
    private Map<String, Object> values;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ ReferenceCountedOpenSslEngine this$0;

    ReferenceCountedOpenSslEngine$OpenSslSession(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, OpenSslSessionContext openSslSessionContext) {
        this.this$0 = referenceCountedOpenSslEngine;
        this.sessionContext = openSslSessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getId() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.id == null) {
                return EmptyArrays.EMPTY_BYTES;
            }
            return (byte[])this.id.clone();
        }
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCreationTime() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.creationTime == 0L && !ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
                this.creationTime = SSL.getTime((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) * 1000L;
            }
        }
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        long l2 = ReferenceCountedOpenSslEngine.access$300(this.this$0);
        return l2 == -1L ? this.getCreationTime() : l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (!ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
                SSL.setTimeout((long)ReferenceCountedOpenSslEngine.access$200(this.this$0), (long)0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (!ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
                return System.currentTimeMillis() - SSL.getTimeout((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) * 1000L < SSL.getTime((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) * 1000L;
            }
        }
        return false;
    }

    @Override
    public void putValue(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (object == null) {
            throw new NullPointerException("value");
        }
        Map<String, Object> map = this.values;
        if (map == null) {
            map = this.values = new HashMap<String, Object>(2);
        }
        Object object2 = map.put(string, object);
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
        }
        this.notifyUnbound(object2, string);
    }

    @Override
    public Object getValue(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.values == null) {
            return null;
        }
        return this.values.get(string);
    }

    @Override
    public void removeValue(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        Map<String, Object> map = this.values;
        if (map == null) {
            return;
        }
        Object object = map.remove(string);
        this.notifyUnbound(object, string);
    }

    @Override
    public String[] getValueNames() {
        Map<String, Object> map = this.values;
        if (map == null || map.isEmpty()) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        return map.keySet().toArray(new String[map.size()]);
    }

    private void notifyUnbound(Object object, String string) {
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handshakeFinished() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
                throw new SSLException("Already closed");
            }
            this.id = SSL.getSessionId((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
            this.cipher = ReferenceCountedOpenSslEngine.access$400(this.this$0, SSL.getCipherForSSL((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)));
            this.protocol = SSL.getVersion((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
            this.initPeerCerts();
            this.selectApplicationProtocol();
            ReferenceCountedOpenSslEngine.access$500(this.this$0);
            ReferenceCountedOpenSslEngine.access$602(this.this$0, ReferenceCountedOpenSslEngine$HandshakeState.FINISHED);
        }
    }

    private void initPeerCerts() {
        byte[][] byArray = SSL.getPeerCertChain((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
        if (ReferenceCountedOpenSslEngine.access$700(this.this$0)) {
            if (ReferenceCountedOpenSslEngine.access$800((Object[])byArray)) {
                this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
            } else {
                this.peerCerts = new Certificate[byArray.length];
                this.x509PeerCerts = new X509Certificate[byArray.length];
                this.initCerts(byArray, 0);
            }
        } else {
            byte[] byArray2 = SSL.getPeerCertificate((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
            if (ReferenceCountedOpenSslEngine.access$900(byArray2)) {
                this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
            } else if (ReferenceCountedOpenSslEngine.access$800((Object[])byArray)) {
                this.peerCerts = new Certificate[]{new OpenSslX509Certificate(byArray2)};
                this.x509PeerCerts = new X509Certificate[]{new OpenSslJavaxX509Certificate(byArray2)};
            } else {
                this.peerCerts = new Certificate[byArray.length + 1];
                this.x509PeerCerts = new X509Certificate[byArray.length + 1];
                this.peerCerts[0] = new OpenSslX509Certificate(byArray2);
                this.x509PeerCerts[0] = new OpenSslJavaxX509Certificate(byArray2);
                this.initCerts(byArray, 1);
            }
        }
    }

    private void initCerts(byte[][] byArray, int n2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n3 = n2 + i2;
            this.peerCerts[n3] = new OpenSslX509Certificate(byArray[i2]);
            this.x509PeerCerts[n3] = new OpenSslJavaxX509Certificate(byArray[i2]);
        }
    }

    private void selectApplicationProtocol() {
        ApplicationProtocolConfig$SelectedListenerFailureBehavior selectedListenerFailureBehavior = ReferenceCountedOpenSslEngine.access$1000(this.this$0).selectedListenerFailureBehavior();
        List<String> list = ReferenceCountedOpenSslEngine.access$1000(this.this$0).protocols();
        switch (ReferenceCountedOpenSslEngine.access$1000(this.this$0).protocol()) {
            case NONE: {
                break;
            }
            case ALPN: {
                String string = SSL.getAlpnSelected((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
                if (string == null) break;
                ReferenceCountedOpenSslEngine.access$1102(this.this$0, this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string));
                break;
            }
            case NPN: {
                String string = SSL.getNextProtoNegotiated((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
                if (string == null) break;
                ReferenceCountedOpenSslEngine.access$1102(this.this$0, this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string));
                break;
            }
            case NPN_AND_ALPN: {
                String string = SSL.getAlpnSelected((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
                if (string == null) {
                    string = SSL.getNextProtoNegotiated((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
                }
                if (string == null) break;
                ReferenceCountedOpenSslEngine.access$1102(this.this$0, this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string));
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private String selectApplicationProtocol(List<String> list, ApplicationProtocolConfig$SelectedListenerFailureBehavior applicationProtocolConfig$SelectedListenerFailureBehavior, String string) {
        if (applicationProtocolConfig$SelectedListenerFailureBehavior == ApplicationProtocolConfig$SelectedListenerFailureBehavior.ACCEPT) {
            return string;
        }
        int n2 = list.size();
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (list.contains(string)) {
            return string;
        }
        if (applicationProtocolConfig$SelectedListenerFailureBehavior == ApplicationProtocolConfig$SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
            return list.get(n2 - 1);
        }
        throw new SSLException("unknown protocol " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Certificate[] getPeerCertificates() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (ReferenceCountedOpenSslEngine.access$800(this.peerCerts)) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            return (Certificate[])this.peerCerts.clone();
        }
    }

    @Override
    public Certificate[] getLocalCertificates() {
        if (ReferenceCountedOpenSslEngine.access$1200(this.this$0) == null) {
            return null;
        }
        return (Certificate[])ReferenceCountedOpenSslEngine.access$1200(this.this$0).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate[] getPeerCertificateChain() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (ReferenceCountedOpenSslEngine.access$800(this.x509PeerCerts)) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            return (X509Certificate[])this.x509PeerCerts.clone();
        }
    }

    @Override
    public Principal getPeerPrincipal() {
        Certificate[] certificateArray = this.getPeerCertificates();
        return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        Certificate[] certificateArray = ReferenceCountedOpenSslEngine.access$1200(this.this$0);
        if (certificateArray == null || certificateArray.length == 0) {
            return null;
        }
        return ((java.security.cert.X509Certificate)certificateArray[0]).getIssuerX500Principal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCipherSuite() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.cipher == null) {
                return "SSL_NULL_WITH_NULL_NULL";
            }
            return this.cipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProtocol() {
        String string = this.protocol;
        if (string == null) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
            synchronized (referenceCountedOpenSslEngine) {
                string = !ReferenceCountedOpenSslEngine.access$100(this.this$0) ? SSL.getVersion((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) : "";
            }
        }
        return string;
    }

    @Override
    public String getPeerHost() {
        return this.this$0.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.this$0.getPeerPort();
    }

    @Override
    public int getPacketBufferSize() {
        return this.this$0.maxEncryptedPacketLength();
    }

    @Override
    public int getApplicationBufferSize() {
        return this.applicationBufferSize;
    }

    void tryExpandApplicationBufferSize(int n2) {
        if (n2 > ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH && this.applicationBufferSize != ReferenceCountedOpenSslEngine.access$1300()) {
            this.applicationBufferSize = ReferenceCountedOpenSslEngine.access$1300();
        }
    }

    static {
        $assertionsDisabled = !ReferenceCountedOpenSslEngine.class.desiredAssertionStatus();
    }
}

