/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolConfig$SelectorFailureBehavior;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslX509Certificate;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext$1;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext$2;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext$3;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext$4;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext$DefaultOpenSslEngineMap;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslUtils;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
    private static final int DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE = AccessController.doPrivileged(new ReferenceCountedOpenSslContext$1());
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    protected static final int VERIFY_DEPTH = 10;
    protected long ctx;
    private final List<String> unmodifiableCiphers;
    private final long sessionCacheSize;
    private final long sessionTimeout;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeakTracker<ReferenceCountedOpenSslContext> leak;
    private final AbstractReferenceCounted refCnt = new ReferenceCountedOpenSslContext$2(this);
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final String[] protocols;
    final boolean enableOcsp;
    final OpenSslEngineMap engineMap = new ReferenceCountedOpenSslContext$DefaultOpenSslEngineMap(null);
    final ReadWriteLock ctxLock = new ReentrantReadWriteLock();
    private volatile int bioNonApplicationBufferSize = DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;

    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, int n2, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, boolean bl4) {
        this(iterable, cipherSuiteFilter, ReferenceCountedOpenSslContext.toNegotiator(applicationProtocolConfig), l2, l3, n2, certificateArray, clientAuth, stringArray, bl2, bl3, bl4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, int n2, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, boolean bl4) {
        super(bl2);
        OpenSsl.ensureAvailability();
        if (bl3 && !OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported.");
        }
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        this.leak = bl4 ? leakDetector.track(this) : null;
        this.mode = n2;
        this.clientAuth = this.isServer() ? ObjectUtil.checkNotNull(clientAuth, "clientAuth") : ClientAuth.NONE;
        this.protocols = stringArray;
        this.enableOcsp = bl3;
        this.keyCertChain = certificateArray == null ? null : (Certificate[])certificateArray.clone();
        this.unmodifiableCiphers = Arrays.asList(ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(iterable, OpenSsl.DEFAULT_CIPHERS, OpenSsl.availableJavaCipherSuites()));
        this.apn = ObjectUtil.checkNotNull(openSslApplicationProtocolNegotiator, "apn");
        boolean bl5 = false;
        try {
            try {
                this.ctx = SSLContext.make((int)31, (int)n2);
            }
            catch (Exception exception) {
                throw new SSLException("failed to create an SSL_CTX", exception);
            }
            SSLContext.setOptions((long)this.ctx, (int)(SSLContext.getOptions((long)this.ctx) | SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_CIPHER_SERVER_PREFERENCE | SSL.SSL_OP_NO_COMPRESSION | SSL.SSL_OP_NO_TICKET));
            SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | SSL.SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER));
            if (DH_KEY_LENGTH != null) {
                SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
            }
            try {
                SSLContext.setCipherSuite((long)this.ctx, (String)CipherSuiteConverter.toOpenSsl(this.unmodifiableCiphers));
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception);
            }
            List<String> list = openSslApplicationProtocolNegotiator.protocols();
            if (!list.isEmpty()) {
                String[] stringArray2 = list.toArray(new String[list.size()]);
                int n3 = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                switch (openSslApplicationProtocolNegotiator.protocol()) {
                    case NPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray2, (int)n3);
                        break;
                    }
                    case ALPN: {
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray2, (int)n3);
                        break;
                    }
                    case NPN_AND_ALPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray2, (int)n3);
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray2, (int)n3);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (l2 <= 0L) {
                l2 = SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
            }
            this.sessionCacheSize = l2;
            SSLContext.setSessionCacheSize((long)this.ctx, (long)l2);
            if (l3 <= 0L) {
                l3 = SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
            }
            this.sessionTimeout = l3;
            SSLContext.setSessionCacheTimeout((long)this.ctx, (long)l3);
            if (bl3) {
                SSLContext.enableOcsp((long)this.ctx, (boolean)this.isClient());
            }
            bl5 = true;
        }
        finally {
            if (!bl5) {
                this.release();
            }
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig$SelectorFailureBehavior applicationProtocolConfig$SelectorFailureBehavior) {
        switch (applicationProtocolConfig$SelectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public final long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public final long sessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return this.newEngine0(byteBufAllocator, string, n2, true);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl2) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl2);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n2, false), bl2);
    }

    SSLEngine newEngine0(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2) {
        return new ReferenceCountedOpenSslEngine(this, byteBufAllocator, string, n2, bl2, true);
    }

    abstract OpenSslKeyMaterialManager keyMaterialManager();

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.newEngine(byteBufAllocator, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final long context() {
        Lock lock = this.ctxLock.readLock();
        lock.lock();
        try {
            long l2 = this.ctx;
            return l2;
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    @Deprecated
    public void setRejectRemoteInitiatedRenegotiation(boolean bl2) {
        if (!bl2) {
            throw new UnsupportedOperationException("Renegotiation is not supported");
        }
    }

    @Deprecated
    public boolean getRejectRemoteInitiatedRenegotiation() {
        return true;
    }

    public void setBioNonApplicationBufferSize(int n2) {
        this.bioNonApplicationBufferSize = ObjectUtil.checkPositiveOrZero(n2, "bioNonApplicationBufferSize");
    }

    public int getBioNonApplicationBufferSize() {
        return this.bioNonApplicationBufferSize;
    }

    @Deprecated
    public final void setTicketKeys(byte[] byArray) {
        this.sessionContext().setTicketKeys(byArray);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final long sslCtxPointer() {
        Lock lock = this.ctxLock.readLock();
        lock.lock();
        try {
            long l2 = this.ctx;
            return l2;
        }
        finally {
            lock.unlock();
        }
    }

    private void destroy() {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            if (this.ctx != 0L) {
                if (this.enableOcsp) {
                    SSLContext.disableOcsp((long)this.ctx);
                }
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            x509CertificateArray[i2] = new OpenSslX509Certificate(byArray[i2]);
        }
        return x509CertificateArray;
    }

    protected static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    static boolean useExtendedKeyManager(X509KeyManager x509KeyManager) {
        return PlatformDependent.javaVersion() >= 7 && x509KeyManager instanceof X509ExtendedKeyManager;
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted retain(int n2) {
        this.refCnt.retain(n2);
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public final boolean release(int n2) {
        return this.refCnt.release(n2);
    }

    static void setKeyMaterial(long l2, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l4 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            l5 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            if (privateKey != null) {
                l3 = ReferenceCountedOpenSslContext.toBIO(privateKey);
            }
            SSLContext.setCertificateBio((long)l2, (long)l4, (long)l3, (String)(string == null ? "" : string));
            SSLContext.setCertificateChainBio((long)l2, (long)l5, (boolean)true);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("failed to set certificate and key", exception);
        }
        finally {
            ReferenceCountedOpenSslContext.freeBio(l3);
            ReferenceCountedOpenSslContext.freeBio(l4);
            ReferenceCountedOpenSslContext.freeBio(l5);
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    static void freeBio(long l2) {
        if (l2 != 0L) {
            SSL.freeBIO((long)l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(PrivateKey privateKey) {
        if (privateKey == null) {
            return 0L;
        }
        ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
        PemEncoded pemEncoded = PemPrivateKey.toPEM(byteBufAllocator, true, privateKey);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(X509Certificate ... x509CertificateArray) {
        if (x509CertificateArray == null) {
            return 0L;
        }
        if (x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("certChain can't be empty");
        }
        ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PemEncoded pemEncoded) {
        try {
            long l2;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l3 = ReferenceCountedOpenSslContext.newBIO(byteBuf.retainedSlice());
                return l3;
            }
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
            try {
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                l2 = ReferenceCountedOpenSslContext.newBIO(byteBuf2.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout(byteBuf2);
                    }
                }
                finally {
                    byteBuf2.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout(byteBuf2);
                }
            }
            finally {
                byteBuf2.release();
            }
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newBIO(ByteBuf byteBuf) {
        try {
            long l2 = SSL.newMemBIO();
            int n2 = byteBuf.readableBytes();
            if (SSL.bioWrite((long)l2, (long)(OpenSsl.memoryAddress(byteBuf) + (long)byteBuf.readerIndex()), (int)n2) != n2) {
                SSL.freeBIO((long)l2);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            long l3 = l2;
            return l3;
        }
        finally {
            byteBuf.release();
        }
    }

    static /* synthetic */ ResourceLeakTracker access$000(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        return referenceCountedOpenSslContext.leak;
    }

    static /* synthetic */ void access$100(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        referenceCountedOpenSslContext.destroy();
    }

    static /* synthetic */ InternalLogger access$300() {
        return logger;
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        NONE_PROTOCOL_NEGOTIATOR = new ReferenceCountedOpenSslContext$3();
        Integer n2 = null;
        try {
            String string = AccessController.doPrivileged(new ReferenceCountedOpenSslContext$4());
            if (string != null) {
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DH_KEY_LENGTH = n2;
    }
}

