/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.internal.tcnative.CertificateRequestedCallback;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.x500.X500Principal;

final class ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback
implements CertificateRequestedCallback {
    private final OpenSslEngineMap engineMap;
    private final OpenSslKeyMaterialManager keyManagerHolder;

    ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
        this.engineMap = openSslEngineMap;
        this.keyManagerHolder = openSslKeyMaterialManager;
    }

    public CertificateRequestedCallback.KeyMaterial requested(long l2, byte[] byArray, byte[][] byArray2) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l2);
        try {
            X500Principal[] x500PrincipalArray;
            Set<String> set = ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback.supportedClientKeyTypes(byArray);
            String[] stringArray = set.toArray(new String[set.size()]);
            if (byArray2 == null) {
                x500PrincipalArray = null;
            } else {
                x500PrincipalArray = new X500Principal[byArray2.length];
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    x500PrincipalArray[i2] = new X500Principal(byArray2[i2]);
                }
            }
            return this.keyManagerHolder.keyMaterial(referenceCountedOpenSslEngine, stringArray, x500PrincipalArray);
        }
        catch (Throwable throwable) {
            ReferenceCountedOpenSslClientContext.access$000().debug("request of key failed", throwable);
            SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
            sSLHandshakeException.initCause(throwable);
            referenceCountedOpenSslEngine.handshakeException = sSLHandshakeException;
            return null;
        }
    }

    private static Set<String> supportedClientKeyTypes(byte[] byArray) {
        HashSet<String> hashSet = new HashSet<String>(byArray.length);
        for (byte by2 : byArray) {
            String string = ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback.clientKeyType(by2);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static String clientKeyType(byte by2) {
        switch (by2) {
            case 1: {
                return "RSA";
            }
            case 3: {
                return "DH_RSA";
            }
            case 64: {
                return "EC";
            }
            case 65: {
                return "EC_RSA";
            }
            case 66: {
                return "EC_EC";
            }
        }
        return null;
    }
}

