/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslSessionContext$EmptyEnumeration;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SessionTicketKey;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

public abstract class OpenSslSessionContext
implements SSLSessionContext {
    private static final Enumeration<byte[]> EMPTY = new OpenSslSessionContext$EmptyEnumeration();
    private final OpenSslSessionStats stats;
    final ReferenceCountedOpenSslContext context;

    OpenSslSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        this.context = referenceCountedOpenSslContext;
        this.stats = new OpenSslSessionStats(referenceCountedOpenSslContext);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("bytes");
        }
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setTicketKeys(byte[] byArray) {
        if (byArray.length % 48 != 0) {
            throw new IllegalArgumentException("keys.length % 48 != 0");
        }
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[byArray.length / 48];
        int n2 = 0;
        for (int i2 = 0; i2 < sessionTicketKeyArray.length; ++i2) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n2, 16);
            byte[] byArray3 = Arrays.copyOfRange(byArray, n2 += 16, 16);
            byte[] byArray4 = Arrays.copyOfRange(byArray, n2, 16);
            n2 += 16;
            sessionTicketKeyArray[i2 += 16] = new SessionTicketKey(byArray2, byArray3, byArray4);
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])sessionTicketKeyArray);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicketKeys(OpenSslSessionTicketKey ... openSslSessionTicketKeyArray) {
        ObjectUtil.checkNotNull(openSslSessionTicketKeyArray, "keys");
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[openSslSessionTicketKeyArray.length];
        for (int i2 = 0; i2 < sessionTicketKeyArray.length; ++i2) {
            sessionTicketKeyArray[i2] = openSslSessionTicketKeyArray[i2].key;
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])sessionTicketKeyArray);
        }
        finally {
            lock.unlock();
        }
    }

    public abstract void setSessionCacheEnabled(boolean var1);

    public abstract boolean isSessionCacheEnabled();

    public OpenSslSessionStats stats() {
        return this.stats;
    }
}

