/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.internal.tcnative.CertificateVerifier;
import java.security.cert.CertificateException;

public final class OpenSslCertificateException
extends CertificateException {
    private static final long serialVersionUID = 5542675253797129798L;
    private final int errorCode;

    public OpenSslCertificateException(int n2) {
        this((String)null, n2);
    }

    public OpenSslCertificateException(String string, int n2) {
        super(string);
        this.errorCode = OpenSslCertificateException.checkErrorCode(n2);
    }

    public OpenSslCertificateException(String string, Throwable throwable, int n2) {
        super(string, throwable);
        this.errorCode = OpenSslCertificateException.checkErrorCode(n2);
    }

    public OpenSslCertificateException(Throwable throwable, int n2) {
        this(null, throwable, n2);
    }

    public int errorCode() {
        return this.errorCode;
    }

    private static int checkErrorCode(int n2) {
        if (!CertificateVerifier.isValid((int)n2)) {
            throw new IllegalArgumentException("errorCode '" + n2 + "' invalid, see https://www.openssl.org/docs/man1.0.2/apps/verify.html.");
        }
        return n2;
    }
}

