/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... ipFilterRuleArray) {
        if (ipFilterRuleArray == null) {
            throw new NullPointerException("rules");
        }
        this.rules = ipFilterRuleArray;
    }

    @Override
    protected boolean accept(ChannelHandlerContext channelHandlerContext, InetSocketAddress inetSocketAddress) {
        for (IpFilterRule ipFilterRule : this.rules) {
            if (ipFilterRule == null) break;
            if (!ipFilterRule.matches(inetSocketAddress)) continue;
            return ipFilterRule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

