/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import io.netty.handler.ipfilter.IpSubnetFilterRule$1;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

final class IpSubnetFilterRule$Ip6SubnetFilterRule
implements IpFilterRule {
    private static final BigInteger MINUS_ONE;
    private final BigInteger networkAddress;
    private final BigInteger subnetMask;
    private final IpFilterRuleType ruleType;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IpSubnetFilterRule$Ip6SubnetFilterRule(Inet6Address inet6Address, int n2, IpFilterRuleType ipFilterRuleType) {
        if (n2 < 0 || n2 > 128) {
            throw new IllegalArgumentException(String.format("IPv6 requires the subnet prefix to be in range of [0,128]. The prefix was: %d", n2));
        }
        this.subnetMask = IpSubnetFilterRule$Ip6SubnetFilterRule.prefixToSubnetMask(n2);
        this.networkAddress = IpSubnetFilterRule$Ip6SubnetFilterRule.ipToInt(inet6Address).and(this.subnetMask);
        this.ruleType = ipFilterRuleType;
    }

    @Override
    public boolean matches(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress instanceof Inet6Address) {
            BigInteger bigInteger = IpSubnetFilterRule$Ip6SubnetFilterRule.ipToInt((Inet6Address)inetAddress);
            return bigInteger.and(this.subnetMask).equals(this.networkAddress);
        }
        return false;
    }

    @Override
    public IpFilterRuleType ruleType() {
        return this.ruleType;
    }

    private static BigInteger ipToInt(Inet6Address inet6Address) {
        byte[] byArray = inet6Address.getAddress();
        if (!$assertionsDisabled && byArray.length != 16) {
            throw new AssertionError();
        }
        return new BigInteger(byArray);
    }

    private static BigInteger prefixToSubnetMask(int n2) {
        return MINUS_ONE.shiftLeft(128 - n2);
    }

    /* synthetic */ IpSubnetFilterRule$Ip6SubnetFilterRule(Inet6Address inet6Address, int n2, IpFilterRuleType ipFilterRuleType, IpSubnetFilterRule$1 ipSubnetFilterRule$1) {
        this(inet6Address, n2, ipFilterRuleType);
    }

    static {
        $assertionsDisabled = !IpSubnetFilterRule.class.desiredAssertionStatus();
        MINUS_ONE = BigInteger.valueOf(-1L);
    }
}

