/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.SocketAddress;

public abstract class AbstractRemoteAddressFilter<T extends SocketAddress>
extends ChannelInboundHandlerAdapter {
    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        this.handleNewChannel(channelHandlerContext);
        channelHandlerContext.fireChannelRegistered();
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (!this.handleNewChannel(channelHandlerContext)) {
            throw new IllegalStateException("cannot determine to accept or reject a channel: " + channelHandlerContext.channel());
        }
        channelHandlerContext.fireChannelActive();
    }

    private boolean handleNewChannel(ChannelHandlerContext channelHandlerContext) {
        SocketAddress socketAddress = channelHandlerContext.channel().remoteAddress();
        if (socketAddress == null) {
            return false;
        }
        channelHandlerContext.pipeline().remove(this);
        if (this.accept(channelHandlerContext, socketAddress)) {
            this.channelAccepted(channelHandlerContext, socketAddress);
        } else {
            ChannelFuture channelFuture = this.channelRejected(channelHandlerContext, socketAddress);
            if (channelFuture != null) {
                channelFuture.addListener(ChannelFutureListener.CLOSE);
            } else {
                channelHandlerContext.close();
            }
        }
        return true;
    }

    protected abstract boolean accept(ChannelHandlerContext var1, T var2);

    protected void channelAccepted(ChannelHandlerContext channelHandlerContext, T t2) {
    }

    protected ChannelFuture channelRejected(ChannelHandlerContext channelHandlerContext, T t2) {
        return null;
    }
}

