/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.flow;

import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.flow.FlowControlHandler$RecyclableArrayDeque;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class FlowControlHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FlowControlHandler.class);
    private final boolean releaseMessages;
    private FlowControlHandler$RecyclableArrayDeque queue;
    private ChannelConfig config;
    private boolean shouldConsume;

    public FlowControlHandler() {
        this(true);
    }

    public FlowControlHandler(boolean bl2) {
        this.releaseMessages = bl2;
    }

    boolean isQueueEmpty() {
        return this.queue.isEmpty();
    }

    private void destroy() {
        if (this.queue != null) {
            if (!this.queue.isEmpty()) {
                logger.trace("Non-empty queue: {}", (Object)this.queue);
                if (this.releaseMessages) {
                    Object e2;
                    while ((e2 = this.queue.poll()) != null) {
                        ReferenceCountUtil.safeRelease(e2);
                    }
                }
            }
            this.queue.recycle();
            this.queue = null;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.config = channelHandlerContext.channel().config();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
        channelHandlerContext.fireChannelInactive();
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        if (this.dequeue(channelHandlerContext, 1) == 0) {
            this.shouldConsume = true;
            channelHandlerContext.read();
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.queue == null) {
            this.queue = FlowControlHandler$RecyclableArrayDeque.newInstance();
        }
        this.queue.offer(object);
        int n2 = this.shouldConsume ? 1 : 0;
        this.shouldConsume = false;
        this.dequeue(channelHandlerContext, n2);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
    }

    private int dequeue(ChannelHandlerContext channelHandlerContext, int n2) {
        if (this.queue != null) {
            Object e2;
            int n3;
            for (n3 = 0; (n3 < n2 || this.config.isAutoRead()) && (e2 = this.queue.poll()) != null; ++n3) {
                channelHandlerContext.fireChannelRead(e2);
            }
            if (this.queue.isEmpty() && n3 > 0) {
                channelHandlerContext.fireChannelReadComplete();
            }
            return n3;
        }
        return 0;
    }
}

