/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.xml;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class XmlFrameDecoder
extends ByteToMessageDecoder {
    private final int maxFrameLength;

    public XmlFrameDecoder(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("maxFrameLength must be a positive int");
        }
        this.maxFrameLength = n2;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n2;
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        long l2 = 0L;
        int n4 = 0;
        int n5 = 0;
        int n6 = byteBuf.writerIndex();
        if (n6 > this.maxFrameLength) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            this.fail(n6);
            return;
        }
        block0: for (n3 = byteBuf.readerIndex(); n3 < n6; ++n3) {
            byte by2;
            n2 = byteBuf.getByte(n3);
            if (!bl2 && Character.isWhitespace(n2)) {
                ++n5;
                continue;
            }
            if (!bl2 && n2 != 60) {
                XmlFrameDecoder.fail(channelHandlerContext);
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            if (!bl4 && n2 == 60) {
                bl2 = true;
                if (n3 >= n6 - 1) continue;
                by2 = byteBuf.getByte(n3 + 1);
                if (by2 == 47) {
                    for (int i2 = n3 + 2; i2 <= n6 - 1; ++i2) {
                        if (byteBuf.getByte(i2) != 62) continue;
                        --l2;
                        continue block0;
                    }
                    continue;
                }
                if (XmlFrameDecoder.isValidStartCharForXmlElement(by2)) {
                    bl3 = true;
                    ++l2;
                    continue;
                }
                if (by2 == 33) {
                    if (XmlFrameDecoder.isCommentBlockStart(byteBuf, n3)) {
                        ++l2;
                        continue;
                    }
                    if (!XmlFrameDecoder.isCDATABlockStart(byteBuf, n3)) continue;
                    ++l2;
                    bl4 = true;
                    continue;
                }
                if (by2 != 63) continue;
                ++l2;
                continue;
            }
            if (!bl4 && n2 == 47) {
                if (n3 >= n6 - 1 || byteBuf.getByte(n3 + 1) != 62) continue;
                --l2;
                continue;
            }
            if (n2 != 62) continue;
            n4 = n3 + 1;
            if (n3 - 1 > -1) {
                by2 = byteBuf.getByte(n3 - 1);
                if (!bl4) {
                    if (by2 == 63) {
                        --l2;
                    } else if (by2 == 45 && n3 - 2 > -1 && byteBuf.getByte(n3 - 2) == 45) {
                        --l2;
                    }
                } else if (by2 == 93 && n3 - 2 > -1 && byteBuf.getByte(n3 - 2) == 93) {
                    --l2;
                    bl4 = false;
                }
            }
            if (bl3 && l2 == 0L) break;
        }
        n3 = byteBuf.readerIndex();
        n2 = n4 - n3;
        if (l2 == 0L && n2 > 0) {
            if (n3 + n2 >= n6) {
                n2 = byteBuf.readableBytes();
            }
            ByteBuf byteBuf2 = XmlFrameDecoder.extractFrame(byteBuf, n3 + n5, n2 - n5);
            byteBuf.skipBytes(n2);
            list.add(byteBuf2);
        }
    }

    private void fail(long l2) {
        if (l2 > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + l2 + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static void fail(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.fireExceptionCaught(new CorruptedFrameException("frame contains content before the xml starts"));
    }

    private static ByteBuf extractFrame(ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.copy(n2, n3);
    }

    private static boolean isValidStartCharForXmlElement(byte by2) {
        return by2 >= 97 && by2 <= 122 || by2 >= 65 && by2 <= 90 || by2 == 58 || by2 == 95;
    }

    private static boolean isCommentBlockStart(ByteBuf byteBuf, int n2) {
        return n2 < byteBuf.writerIndex() - 3 && byteBuf.getByte(n2 + 2) == 45 && byteBuf.getByte(n2 + 3) == 45;
    }

    private static boolean isCDATABlockStart(ByteBuf byteBuf, int n2) {
        return n2 < byteBuf.writerIndex() - 8 && byteBuf.getByte(n2 + 2) == 91 && byteBuf.getByte(n2 + 3) == 67 && byteBuf.getByte(n2 + 4) == 68 && byteBuf.getByte(n2 + 5) == 65 && byteBuf.getByte(n2 + 6) == 84 && byteBuf.getByte(n2 + 7) == 65 && byteBuf.getByte(n2 + 8) == 91;
    }
}

