/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.stomp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.stomp.DefaultStompHeaders;
import io.netty.handler.codec.stomp.DefaultStompHeadersSubframe;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.util.CharsetUtil;

public class DefaultStompFrame
extends DefaultStompHeadersSubframe
implements StompFrame {
    private final ByteBuf content;

    public DefaultStompFrame(StompCommand stompCommand) {
        this(stompCommand, Unpooled.buffer(0));
    }

    public DefaultStompFrame(StompCommand stompCommand, ByteBuf byteBuf) {
        this(stompCommand, byteBuf, null);
    }

    DefaultStompFrame(StompCommand stompCommand, ByteBuf byteBuf, DefaultStompHeaders defaultStompHeaders) {
        super(stompCommand, defaultStompHeaders);
        if (byteBuf == null) {
            throw new NullPointerException("content");
        }
        this.content = byteBuf;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public StompFrame copy() {
        return this.replace(this.content.copy());
    }

    @Override
    public StompFrame duplicate() {
        return this.replace(this.content.duplicate());
    }

    @Override
    public StompFrame retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    @Override
    public StompFrame replace(ByteBuf byteBuf) {
        return new DefaultStompFrame(this.command, byteBuf, this.headers.copy());
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public StompFrame retain() {
        this.content.retain();
        return this;
    }

    @Override
    public StompFrame retain(int n2) {
        this.content.retain(n2);
        return this;
    }

    @Override
    public StompFrame touch() {
        this.content.touch();
        return this;
    }

    @Override
    public StompFrame touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int n2) {
        return this.content.release(n2);
    }

    @Override
    public String toString() {
        return "DefaultStompFrame{command=" + (Object)((Object)this.command) + ", headers=" + this.headers + ", content=" + this.content.toString(CharsetUtil.UTF_8) + '}';
    }
}

