/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyFrame;
import io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyPingFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdySession;
import io.netty.handler.codec.spdy.SpdySession$PendingWrite;
import io.netty.handler.codec.spdy.SpdySessionHandler$1;
import io.netty.handler.codec.spdy.SpdySessionHandler$2;
import io.netty.handler.codec.spdy.SpdySessionHandler$3;
import io.netty.handler.codec.spdy.SpdySessionHandler$4;
import io.netty.handler.codec.spdy.SpdySessionHandler$ClosingChannelFutureListener;
import io.netty.handler.codec.spdy.SpdySessionStatus;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import io.netty.util.internal.ThrowableUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class SpdySessionHandler
extends ChannelDuplexHandler {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = ThrowableUtil.unknownStackTrace(new SpdyProtocolException(), SpdySessionHandler.class, "handleOutboundMessage(...)");
    private static final SpdyProtocolException STREAM_CLOSED = ThrowableUtil.unknownStackTrace(new SpdyProtocolException("Stream closed"), SpdySessionHandler.class, "removeStream(...)");
    private static final int DEFAULT_WINDOW_SIZE = 65536;
    private int initialSendWindowSize = 65536;
    private int initialReceiveWindowSize = 65536;
    private volatile int initialSessionReceiveWindowSize = 65536;
    private final SpdySession spdySession = new SpdySession(this.initialSendWindowSize, this.initialReceiveWindowSize);
    private int lastGoodStreamId;
    private static final int DEFAULT_MAX_CONCURRENT_STREAMS = Integer.MAX_VALUE;
    private int remoteConcurrentStreams = Integer.MAX_VALUE;
    private int localConcurrentStreams = Integer.MAX_VALUE;
    private final AtomicInteger pings = new AtomicInteger();
    private boolean sentGoAwayFrame;
    private boolean receivedGoAwayFrame;
    private ChannelFutureListener closeSessionFutureListener;
    private final boolean server;
    private final int minorVersion;

    public SpdySessionHandler(SpdyVersion spdyVersion, boolean bl2) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
        this.server = bl2;
        this.minorVersion = spdyVersion.getMinorVersion();
    }

    public void setSessionReceiveWindowSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("sessionReceiveWindowSize");
        }
        this.initialSessionReceiveWindowSize = n2;
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof SpdyDataFrame) {
            SpdyFrame spdyFrame;
            int n2;
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)object;
            int n3 = spdyDataFrame.streamId();
            int n4 = -1 * spdyDataFrame.content().readableBytes();
            int n5 = this.spdySession.updateReceiveWindowSize(0, n4);
            if (n5 < 0) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            if (n5 <= this.initialSessionReceiveWindowSize / 2) {
                n2 = this.initialSessionReceiveWindowSize - n5;
                this.spdySession.updateReceiveWindowSize(0, n2);
                spdyFrame = new DefaultSpdyWindowUpdateFrame(0, n2);
                channelHandlerContext.writeAndFlush(spdyFrame);
            }
            if (!this.spdySession.isActiveStream(n3)) {
                spdyDataFrame.release();
                if (n3 <= this.lastGoodStreamId) {
                    this.issueStreamError(channelHandlerContext, n3, SpdyStreamStatus.PROTOCOL_ERROR);
                } else if (!this.sentGoAwayFrame) {
                    this.issueStreamError(channelHandlerContext, n3, SpdyStreamStatus.INVALID_STREAM);
                }
                return;
            }
            if (this.spdySession.isRemoteSideClosed(n3)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n3, SpdyStreamStatus.STREAM_ALREADY_CLOSED);
                return;
            }
            if (!this.isRemoteInitiatedId(n3) && !this.spdySession.hasReceivedReply(n3)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n3, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            n2 = this.spdySession.updateReceiveWindowSize(n3, n4);
            if (n2 < this.spdySession.getReceiveWindowSizeLowerBound(n3)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n3, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                return;
            }
            if (n2 < 0) {
                while (spdyDataFrame.content().readableBytes() > this.initialReceiveWindowSize) {
                    spdyFrame = new DefaultSpdyDataFrame(n3, spdyDataFrame.content().readRetainedSlice(this.initialReceiveWindowSize));
                    channelHandlerContext.writeAndFlush(spdyFrame);
                }
            }
            if (n2 <= this.initialReceiveWindowSize / 2 && !spdyDataFrame.isLast()) {
                int n6 = this.initialReceiveWindowSize - n2;
                this.spdySession.updateReceiveWindowSize(n3, n6);
                DefaultSpdyWindowUpdateFrame defaultSpdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(n3, n6);
                channelHandlerContext.writeAndFlush(defaultSpdyWindowUpdateFrame);
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n3, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdySynStreamFrame) {
            boolean bl2;
            boolean bl3;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)object;
            int n7 = spdySynStreamFrame.streamId();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedId(n7) || this.spdySession.isActiveStream(n7)) {
                this.issueStreamError(channelHandlerContext, n7, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (n7 <= this.lastGoodStreamId) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            byte by2 = spdySynStreamFrame.priority();
            if (!this.acceptStream(n7, by2, bl3 = spdySynStreamFrame.isLast(), bl2 = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(channelHandlerContext, n7, SpdyStreamStatus.REFUSED_STREAM);
                return;
            }
        } else if (object instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)object;
            int n8 = spdySynReplyFrame.streamId();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedId(n8) || this.spdySession.isRemoteSideClosed(n8)) {
                this.issueStreamError(channelHandlerContext, n8, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (this.spdySession.hasReceivedReply(n8)) {
                this.issueStreamError(channelHandlerContext, n8, SpdyStreamStatus.STREAM_IN_USE);
                return;
            }
            this.spdySession.receivedReply(n8);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(n8, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)object;
            this.removeStream(spdyRstStreamFrame.streamId(), channelHandlerContext.newSucceededFuture());
        } else if (object instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)object;
            int n9 = spdySettingsFrame.getValue(0);
            if (n9 >= 0 && n9 != this.minorVersion) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            int n10 = spdySettingsFrame.getValue(4);
            if (n10 >= 0) {
                this.remoteConcurrentStreams = n10;
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            int n11 = spdySettingsFrame.getValue(7);
            if (n11 >= 0) {
                this.updateInitialSendWindowSize(n11);
            }
        } else if (object instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)object;
            if (this.isRemoteInitiatedId(spdyPingFrame.id())) {
                channelHandlerContext.writeAndFlush(spdyPingFrame);
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (object instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (object instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)object;
            int n12 = spdyHeadersFrame.streamId();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(channelHandlerContext, n12, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(n12)) {
                this.issueStreamError(channelHandlerContext, n12, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (spdyHeadersFrame.isLast()) {
                this.halfCloseStream(n12, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdyWindowUpdateFrame) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)object;
            int n13 = spdyWindowUpdateFrame.streamId();
            int n14 = spdyWindowUpdateFrame.deltaWindowSize();
            if (n13 != 0 && this.spdySession.isLocalSideClosed(n13)) {
                return;
            }
            if (this.spdySession.getSendWindowSize(n13) > Integer.MAX_VALUE - n14) {
                if (n13 == 0) {
                    this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                } else {
                    this.issueStreamError(channelHandlerContext, n13, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                }
                return;
            }
            this.updateSendWindowSize(channelHandlerContext, n13, n14);
        }
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        for (Integer n2 : this.spdySession.activeStreams().keySet()) {
            this.removeStream(n2, channelHandlerContext.newSucceededFuture());
        }
        channelHandlerContext.fireChannelInactive();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof SpdyProtocolException) {
            this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
        }
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.sendGoAwayFrame(channelHandlerContext, channelPromise);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame || object instanceof SpdySynStreamFrame || object instanceof SpdySynReplyFrame || object instanceof SpdyRstStreamFrame || object instanceof SpdySettingsFrame || object instanceof SpdyPingFrame || object instanceof SpdyGoAwayFrame || object instanceof SpdyHeadersFrame || object instanceof SpdyWindowUpdateFrame) {
            this.handleOutboundMessage(channelHandlerContext, object, channelPromise);
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    private void handleOutboundMessage(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)object;
            int n2 = spdyDataFrame.streamId();
            if (this.spdySession.isLocalSideClosed(n2)) {
                spdyDataFrame.release();
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            int n3 = spdyDataFrame.content().readableBytes();
            int n4 = this.spdySession.getSendWindowSize(n2);
            int n5 = this.spdySession.getSendWindowSize(0);
            if ((n4 = Math.min(n4, n5)) <= 0) {
                this.spdySession.putPendingWrite(n2, new SpdySession$PendingWrite(spdyDataFrame, channelPromise));
                return;
            }
            if (n4 < n3) {
                this.spdySession.updateSendWindowSize(n2, -1 * n4);
                this.spdySession.updateSendWindowSize(0, -1 * n4);
                DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n2, spdyDataFrame.content().readRetainedSlice(n4));
                this.spdySession.putPendingWrite(n2, new SpdySession$PendingWrite(spdyDataFrame, channelPromise));
                ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
                channelHandlerContext.write(defaultSpdyDataFrame).addListener(new SpdySessionHandler$1(this, channelHandlerContext2));
                return;
            }
            this.spdySession.updateSendWindowSize(n2, -1 * n3);
            this.spdySession.updateSendWindowSize(0, -1 * n3);
            ChannelHandlerContext channelHandlerContext3 = channelHandlerContext;
            channelPromise.addListener(new SpdySessionHandler$2(this, channelHandlerContext3));
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n2, false, channelPromise);
            }
        } else if (object instanceof SpdySynStreamFrame) {
            boolean bl2;
            boolean bl3;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)object;
            int n6 = spdySynStreamFrame.streamId();
            if (this.isRemoteInitiatedId(n6)) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            byte by2 = spdySynStreamFrame.priority();
            if (!this.acceptStream(n6, by2, bl3 = spdySynStreamFrame.isUnidirectional(), bl2 = spdySynStreamFrame.isLast())) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        } else if (object instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)object;
            int n7 = spdySynReplyFrame.streamId();
            if (!this.isRemoteInitiatedId(n7) || this.spdySession.isLocalSideClosed(n7)) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(n7, false, channelPromise);
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)object;
            this.removeStream(spdyRstStreamFrame.streamId(), channelPromise);
        } else if (object instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)object;
            int n8 = spdySettingsFrame.getValue(0);
            if (n8 >= 0 && n8 != this.minorVersion) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            int n9 = spdySettingsFrame.getValue(4);
            if (n9 >= 0) {
                this.localConcurrentStreams = n9;
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            int n10 = spdySettingsFrame.getValue(7);
            if (n10 >= 0) {
                this.updateInitialReceiveWindowSize(n10);
            }
        } else if (object instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)object;
            if (this.isRemoteInitiatedId(spdyPingFrame.id())) {
                channelHandlerContext.fireExceptionCaught(new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.id()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            if (object instanceof SpdyGoAwayFrame) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (object instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)object;
                int n11 = spdyHeadersFrame.streamId();
                if (this.spdySession.isLocalSideClosed(n11)) {
                    channelPromise.setFailure(PROTOCOL_EXCEPTION);
                    return;
                }
                if (spdyHeadersFrame.isLast()) {
                    this.halfCloseStream(n11, false, channelPromise);
                }
            } else if (object instanceof SpdyWindowUpdateFrame) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        }
        channelHandlerContext.write(object, channelPromise);
    }

    private void issueSessionError(ChannelHandlerContext channelHandlerContext, SpdySessionStatus spdySessionStatus) {
        this.sendGoAwayFrame(channelHandlerContext, spdySessionStatus).addListener(new SpdySessionHandler$ClosingChannelFutureListener(channelHandlerContext, channelHandlerContext.newPromise()));
    }

    private void issueStreamError(ChannelHandlerContext channelHandlerContext, int n2, SpdyStreamStatus spdyStreamStatus) {
        boolean bl2 = !this.spdySession.isRemoteSideClosed(n2);
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        this.removeStream(n2, channelPromise);
        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n2, spdyStreamStatus);
        channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame, channelPromise);
        if (bl2) {
            channelHandlerContext.fireChannelRead(defaultSpdyRstStreamFrame);
        }
    }

    private boolean isRemoteInitiatedId(int n2) {
        boolean bl2 = SpdyCodecUtil.isServerId(n2);
        return this.server && !bl2 || !this.server && bl2;
    }

    private void updateInitialSendWindowSize(int n2) {
        int n3 = n2 - this.initialSendWindowSize;
        this.initialSendWindowSize = n2;
        this.spdySession.updateAllSendWindowSizes(n3);
    }

    private void updateInitialReceiveWindowSize(int n2) {
        int n3 = n2 - this.initialReceiveWindowSize;
        this.initialReceiveWindowSize = n2;
        this.spdySession.updateAllReceiveWindowSizes(n3);
    }

    private boolean acceptStream(int n2, byte by2, boolean bl2, boolean bl3) {
        int n3;
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        boolean bl4 = this.isRemoteInitiatedId(n2);
        int n4 = n3 = bl4 ? this.localConcurrentStreams : this.remoteConcurrentStreams;
        if (this.spdySession.numActiveStreams(bl4) >= n3) {
            return false;
        }
        this.spdySession.acceptStream(n2, by2, bl2, bl3, this.initialSendWindowSize, this.initialReceiveWindowSize, bl4);
        if (bl4) {
            this.lastGoodStreamId = n2;
        }
        return true;
    }

    private void halfCloseStream(int n2, boolean bl2, ChannelFuture channelFuture) {
        if (bl2) {
            this.spdySession.closeRemoteSide(n2, this.isRemoteInitiatedId(n2));
        } else {
            this.spdySession.closeLocalSide(n2, this.isRemoteInitiatedId(n2));
        }
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            channelFuture.addListener(this.closeSessionFutureListener);
        }
    }

    private void removeStream(int n2, ChannelFuture channelFuture) {
        this.spdySession.removeStream(n2, STREAM_CLOSED, this.isRemoteInitiatedId(n2));
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            channelFuture.addListener(this.closeSessionFutureListener);
        }
    }

    private void updateSendWindowSize(ChannelHandlerContext channelHandlerContext, int n2, int n3) {
        this.spdySession.updateSendWindowSize(n2, n3);
        SpdySession$PendingWrite spdySession$PendingWrite;
        while ((spdySession$PendingWrite = this.spdySession.getPendingWrite(n2)) != null) {
            SpdyDataFrame spdyDataFrame = spdySession$PendingWrite.spdyDataFrame;
            int n4 = spdyDataFrame.content().readableBytes();
            int n5 = spdyDataFrame.streamId();
            int n6 = this.spdySession.getSendWindowSize(n5);
            int n7 = this.spdySession.getSendWindowSize(0);
            if ((n6 = Math.min(n6, n7)) <= 0) {
                return;
            }
            if (n6 < n4) {
                this.spdySession.updateSendWindowSize(n5, -1 * n6);
                this.spdySession.updateSendWindowSize(0, -1 * n6);
                DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n5, spdyDataFrame.content().readRetainedSlice(n6));
                channelHandlerContext.writeAndFlush(defaultSpdyDataFrame).addListener(new SpdySessionHandler$3(this, channelHandlerContext));
                continue;
            }
            this.spdySession.removePendingWrite(n5);
            this.spdySession.updateSendWindowSize(n5, -1 * n4);
            this.spdySession.updateSendWindowSize(0, -1 * n4);
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n5, false, spdySession$PendingWrite.promise);
            }
            channelHandlerContext.writeAndFlush(spdyDataFrame, spdySession$PendingWrite.promise).addListener(new SpdySessionHandler$4(this, channelHandlerContext));
        }
        return;
    }

    private void sendGoAwayFrame(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ChannelFuture channelFuture = this.sendGoAwayFrame(channelHandlerContext, SpdySessionStatus.OK);
        if (this.spdySession.noActiveStreams()) {
            channelFuture.addListener(new SpdySessionHandler$ClosingChannelFutureListener(channelHandlerContext, channelPromise));
        } else {
            this.closeSessionFutureListener = new SpdySessionHandler$ClosingChannelFutureListener(channelHandlerContext, channelPromise);
        }
    }

    private ChannelFuture sendGoAwayFrame(ChannelHandlerContext channelHandlerContext, SpdySessionStatus spdySessionStatus) {
        if (!this.sentGoAwayFrame) {
            this.sentGoAwayFrame = true;
            DefaultSpdyGoAwayFrame defaultSpdyGoAwayFrame = new DefaultSpdyGoAwayFrame(this.lastGoodStreamId, spdySessionStatus);
            return channelHandlerContext.writeAndFlush(defaultSpdyGoAwayFrame);
        }
        return channelHandlerContext.newSucceededFuture();
    }

    static /* synthetic */ void access$000(SpdySessionHandler spdySessionHandler, ChannelHandlerContext channelHandlerContext, SpdySessionStatus spdySessionStatus) {
        spdySessionHandler.issueSessionError(channelHandlerContext, spdySessionStatus);
    }
}

