/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.SpdySession$PendingWrite;
import io.netty.handler.codec.spdy.SpdySession$StreamComparator;
import io.netty.handler.codec.spdy.SpdySession$StreamState;
import io.netty.util.internal.PlatformDependent;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

final class SpdySession {
    private final AtomicInteger activeLocalStreams = new AtomicInteger();
    private final AtomicInteger activeRemoteStreams = new AtomicInteger();
    private final Map<Integer, SpdySession$StreamState> activeStreams = PlatformDependent.newConcurrentHashMap();
    private final SpdySession$StreamComparator streamComparator = new SpdySession$StreamComparator(this);
    private final AtomicInteger sendWindowSize;
    private final AtomicInteger receiveWindowSize;

    SpdySession(int n2, int n3) {
        this.sendWindowSize = new AtomicInteger(n2);
        this.receiveWindowSize = new AtomicInteger(n3);
    }

    int numActiveStreams(boolean bl2) {
        if (bl2) {
            return this.activeRemoteStreams.get();
        }
        return this.activeLocalStreams.get();
    }

    boolean noActiveStreams() {
        return this.activeStreams.isEmpty();
    }

    boolean isActiveStream(int n2) {
        return this.activeStreams.containsKey(n2);
    }

    Map<Integer, SpdySession$StreamState> activeStreams() {
        TreeMap<Integer, SpdySession$StreamState> treeMap = new TreeMap<Integer, SpdySession$StreamState>(this.streamComparator);
        treeMap.putAll(this.activeStreams);
        return treeMap;
    }

    void acceptStream(int n2, byte by2, boolean bl2, boolean bl3, int n3, int n4, boolean bl4) {
        SpdySession$StreamState spdySession$StreamState;
        if (!(bl2 && bl3 || (spdySession$StreamState = this.activeStreams.put(n2, new SpdySession$StreamState(by2, bl2, bl3, n3, n4))) != null)) {
            if (bl4) {
                this.activeRemoteStreams.incrementAndGet();
            } else {
                this.activeLocalStreams.incrementAndGet();
            }
        }
    }

    private SpdySession$StreamState removeActiveStream(int n2, boolean bl2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.remove(n2);
        if (spdySession$StreamState != null) {
            if (bl2) {
                this.activeRemoteStreams.decrementAndGet();
            } else {
                this.activeLocalStreams.decrementAndGet();
            }
        }
        return spdySession$StreamState;
    }

    void removeStream(int n2, Throwable throwable, boolean bl2) {
        SpdySession$StreamState spdySession$StreamState = this.removeActiveStream(n2, bl2);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.clearPendingWrites(throwable);
        }
    }

    boolean isRemoteSideClosed(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState == null || spdySession$StreamState.isRemoteSideClosed();
    }

    void closeRemoteSide(int n2, boolean bl2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.closeRemoteSide();
            if (spdySession$StreamState.isLocalSideClosed()) {
                this.removeActiveStream(n2, bl2);
            }
        }
    }

    boolean isLocalSideClosed(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState == null || spdySession$StreamState.isLocalSideClosed();
    }

    void closeLocalSide(int n2, boolean bl2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.closeLocalSide();
            if (spdySession$StreamState.isRemoteSideClosed()) {
                this.removeActiveStream(n2, bl2);
            }
        }
    }

    boolean hasReceivedReply(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null && spdySession$StreamState.hasReceivedReply();
    }

    void receivedReply(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.receivedReply();
        }
    }

    int getSendWindowSize(int n2) {
        if (n2 == 0) {
            return this.sendWindowSize.get();
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null ? spdySession$StreamState.getSendWindowSize() : -1;
    }

    int updateSendWindowSize(int n2, int n3) {
        if (n2 == 0) {
            return this.sendWindowSize.addAndGet(n3);
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null ? spdySession$StreamState.updateSendWindowSize(n3) : -1;
    }

    int updateReceiveWindowSize(int n2, int n3) {
        if (n2 == 0) {
            return this.receiveWindowSize.addAndGet(n3);
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState == null) {
            return -1;
        }
        if (n3 > 0) {
            spdySession$StreamState.setReceiveWindowSizeLowerBound(0);
        }
        return spdySession$StreamState.updateReceiveWindowSize(n3);
    }

    int getReceiveWindowSizeLowerBound(int n2) {
        if (n2 == 0) {
            return 0;
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null ? spdySession$StreamState.getReceiveWindowSizeLowerBound() : 0;
    }

    void updateAllSendWindowSizes(int n2) {
        for (SpdySession$StreamState spdySession$StreamState : this.activeStreams.values()) {
            spdySession$StreamState.updateSendWindowSize(n2);
        }
    }

    void updateAllReceiveWindowSizes(int n2) {
        for (SpdySession$StreamState spdySession$StreamState : this.activeStreams.values()) {
            spdySession$StreamState.updateReceiveWindowSize(n2);
            if (n2 >= 0) continue;
            spdySession$StreamState.setReceiveWindowSizeLowerBound(n2);
        }
    }

    boolean putPendingWrite(int n2, SpdySession$PendingWrite spdySession$PendingWrite) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null && spdySession$StreamState.putPendingWrite(spdySession$PendingWrite);
    }

    SpdySession$PendingWrite getPendingWrite(int n2) {
        if (n2 == 0) {
            for (Map.Entry<Integer, SpdySession$StreamState> entry : this.activeStreams().entrySet()) {
                SpdySession$PendingWrite spdySession$PendingWrite;
                SpdySession$StreamState spdySession$StreamState = entry.getValue();
                if (spdySession$StreamState.getSendWindowSize() <= 0 || (spdySession$PendingWrite = spdySession$StreamState.getPendingWrite()) == null) continue;
                return spdySession$PendingWrite;
            }
            return null;
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null ? spdySession$StreamState.getPendingWrite() : null;
    }

    SpdySession$PendingWrite removePendingWrite(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null ? spdySession$StreamState.removePendingWrite() : null;
    }

    static /* synthetic */ Map access$000(SpdySession spdySession) {
        return spdySession.activeStreams;
    }
}

