/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.SpdySession$PendingWrite;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

final class SpdySession$StreamState {
    private final byte priority;
    private boolean remoteSideClosed;
    private boolean localSideClosed;
    private boolean receivedReply;
    private final AtomicInteger sendWindowSize;
    private final AtomicInteger receiveWindowSize;
    private int receiveWindowSizeLowerBound;
    private final Queue<SpdySession$PendingWrite> pendingWriteQueue = new ConcurrentLinkedQueue<SpdySession$PendingWrite>();

    SpdySession$StreamState(byte by2, boolean bl2, boolean bl3, int n2, int n3) {
        this.priority = by2;
        this.remoteSideClosed = bl2;
        this.localSideClosed = bl3;
        this.sendWindowSize = new AtomicInteger(n2);
        this.receiveWindowSize = new AtomicInteger(n3);
    }

    byte getPriority() {
        return this.priority;
    }

    boolean isRemoteSideClosed() {
        return this.remoteSideClosed;
    }

    void closeRemoteSide() {
        this.remoteSideClosed = true;
    }

    boolean isLocalSideClosed() {
        return this.localSideClosed;
    }

    void closeLocalSide() {
        this.localSideClosed = true;
    }

    boolean hasReceivedReply() {
        return this.receivedReply;
    }

    void receivedReply() {
        this.receivedReply = true;
    }

    int getSendWindowSize() {
        return this.sendWindowSize.get();
    }

    int updateSendWindowSize(int n2) {
        return this.sendWindowSize.addAndGet(n2);
    }

    int updateReceiveWindowSize(int n2) {
        return this.receiveWindowSize.addAndGet(n2);
    }

    int getReceiveWindowSizeLowerBound() {
        return this.receiveWindowSizeLowerBound;
    }

    void setReceiveWindowSizeLowerBound(int n2) {
        this.receiveWindowSizeLowerBound = n2;
    }

    boolean putPendingWrite(SpdySession$PendingWrite spdySession$PendingWrite) {
        return this.pendingWriteQueue.offer(spdySession$PendingWrite);
    }

    SpdySession$PendingWrite getPendingWrite() {
        return this.pendingWriteQueue.peek();
    }

    SpdySession$PendingWrite removePendingWrite() {
        return this.pendingWriteQueue.poll();
    }

    void clearPendingWrites(Throwable throwable) {
        SpdySession$PendingWrite spdySession$PendingWrite;
        while ((spdySession$PendingWrite = this.pendingWriteQueue.poll()) != null) {
            spdySession$PendingWrite.fail(throwable);
        }
    }
}

