/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import java.util.Set;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
        this.version = spdyVersion.getVersion();
    }

    private static void setLengthField(ByteBuf byteBuf, int n2, int n3) {
        byteBuf.setInt(n2, n3);
    }

    private static void writeLengthField(ByteBuf byteBuf, int n2) {
        byteBuf.writeInt(n2);
    }

    @Override
    public ByteBuf encode(ByteBufAllocator byteBufAllocator, SpdyHeadersFrame spdyHeadersFrame) {
        Set set = spdyHeadersFrame.headers().names();
        int n2 = set.size();
        if (n2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (n2 > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ByteBuf byteBuf = byteBufAllocator.heapBuffer();
        SpdyHeaderBlockRawEncoder.writeLengthField(byteBuf, n2);
        for (CharSequence charSequence : set) {
            SpdyHeaderBlockRawEncoder.writeLengthField(byteBuf, charSequence.length());
            ByteBufUtil.writeAscii(byteBuf, charSequence);
            int n3 = byteBuf.writerIndex();
            int n4 = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField(byteBuf, n4);
            for (CharSequence charSequence2 : spdyHeadersFrame.headers().getAll(charSequence)) {
                int n5 = charSequence2.length();
                if (n5 <= 0) continue;
                ByteBufUtil.writeAscii(byteBuf, charSequence2);
                byteBuf.writeByte(0);
                n4 += n5 + 1;
            }
            if (n4 != 0) {
                --n4;
            }
            if (n4 > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + charSequence);
            }
            if (n4 <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField(byteBuf, n3, n4);
            byteBuf.writerIndex(byteBuf.writerIndex() - 1);
        }
        return byteBuf;
    }

    @Override
    void end() {
    }
}

