/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import java.nio.ByteOrder;
import java.util.Set;

public class SpdyFrameEncoder {
    private final int version;

    public SpdyFrameEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        this.version = spdyVersion.getVersion();
    }

    private void writeControlFrameHeader(ByteBuf byteBuf, int n2, byte by2, int n3) {
        byteBuf.writeShort(this.version | 0x8000);
        byteBuf.writeShort(n2);
        byteBuf.writeByte(by2);
        byteBuf.writeMedium(n3);
    }

    public ByteBuf encodeDataFrame(ByteBufAllocator byteBufAllocator, int n2, boolean bl2, ByteBuf byteBuf) {
        int n3 = bl2 ? 1 : 0;
        int n4 = byteBuf.readableBytes();
        ByteBuf byteBuf2 = byteBufAllocator.ioBuffer(8 + n4).order(ByteOrder.BIG_ENDIAN);
        byteBuf2.writeInt(n2 & Integer.MAX_VALUE);
        byteBuf2.writeByte(n3);
        byteBuf2.writeMedium(n4);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
        return byteBuf2;
    }

    public ByteBuf encodeSynStreamFrame(ByteBufAllocator byteBufAllocator, int n2, int n3, byte by2, boolean bl2, boolean bl3, ByteBuf byteBuf) {
        byte by3;
        int n4 = byteBuf.readableBytes();
        byte by4 = by3 = bl2 ? (byte)1 : 0;
        if (bl3) {
            by3 = (byte)(by3 | 2);
        }
        int n5 = 10 + n4;
        ByteBuf byteBuf2 = byteBufAllocator.ioBuffer(8 + n5).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf2, 1, by3, n5);
        byteBuf2.writeInt(n2);
        byteBuf2.writeInt(n3);
        byteBuf2.writeShort((by2 & 0xFF) << 13);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
        return byteBuf2;
    }

    public ByteBuf encodeSynReplyFrame(ByteBufAllocator byteBufAllocator, int n2, boolean bl2, ByteBuf byteBuf) {
        int n3 = byteBuf.readableBytes();
        byte by2 = bl2 ? (byte)1 : 0;
        int n4 = 4 + n3;
        ByteBuf byteBuf2 = byteBufAllocator.ioBuffer(8 + n4).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf2, 2, by2, n4);
        byteBuf2.writeInt(n2);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n3);
        return byteBuf2;
    }

    public ByteBuf encodeRstStreamFrame(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        byte by2 = 0;
        int n4 = 8;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n4).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 3, by2, n4);
        byteBuf.writeInt(n2);
        byteBuf.writeInt(n3);
        return byteBuf;
    }

    public ByteBuf encodeSettingsFrame(ByteBufAllocator byteBufAllocator, SpdySettingsFrame spdySettingsFrame) {
        Set<Integer> set = spdySettingsFrame.ids();
        int n2 = set.size();
        byte by2 = spdySettingsFrame.clearPreviouslyPersistedSettings() ? (byte)1 : 0;
        int n3 = 4 + 8 * n2;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n3).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 4, by2, n3);
        byteBuf.writeInt(n2);
        for (Integer n4 : set) {
            by2 = 0;
            if (spdySettingsFrame.isPersistValue(n4)) {
                by2 = (byte)(by2 | 1);
            }
            if (spdySettingsFrame.isPersisted(n4)) {
                by2 = (byte)(by2 | 2);
            }
            byteBuf.writeByte(by2);
            byteBuf.writeMedium(n4);
            byteBuf.writeInt(spdySettingsFrame.getValue(n4));
        }
        return byteBuf;
    }

    public ByteBuf encodePingFrame(ByteBufAllocator byteBufAllocator, int n2) {
        byte by2 = 0;
        int n3 = 4;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n3).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 6, by2, n3);
        byteBuf.writeInt(n2);
        return byteBuf;
    }

    public ByteBuf encodeGoAwayFrame(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        byte by2 = 0;
        int n4 = 8;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n4).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 7, by2, n4);
        byteBuf.writeInt(n2);
        byteBuf.writeInt(n3);
        return byteBuf;
    }

    public ByteBuf encodeHeadersFrame(ByteBufAllocator byteBufAllocator, int n2, boolean bl2, ByteBuf byteBuf) {
        int n3 = byteBuf.readableBytes();
        byte by2 = bl2 ? (byte)1 : 0;
        int n4 = 4 + n3;
        ByteBuf byteBuf2 = byteBufAllocator.ioBuffer(8 + n4).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf2, 8, by2, n4);
        byteBuf2.writeInt(n2);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n3);
        return byteBuf2;
    }

    public ByteBuf encodeWindowUpdateFrame(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        byte by2 = 0;
        int n4 = 8;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n4).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 9, by2, n4);
        byteBuf.writeInt(n2);
        byteBuf.writeInt(n3);
        return byteBuf;
    }
}

