/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.DefaultSpdyPingFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySettingsFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyFrameCodec$1;
import io.netty.handler.codec.spdy.SpdyFrameDecoder;
import io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import io.netty.handler.codec.spdy.SpdyFrameEncoder;
import io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.netty.handler.codec.spdy.SpdyHeaderBlockDecoder;
import io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyPingFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import java.net.SocketAddress;
import java.util.List;

public class SpdyFrameCodec
extends ByteToMessageDecoder
implements ChannelOutboundHandler,
SpdyFrameDecoderDelegate {
    private static final SpdyProtocolException INVALID_FRAME = new SpdyProtocolException("Received invalid frame");
    private final SpdyFrameDecoder spdyFrameDecoder;
    private final SpdyFrameEncoder spdyFrameEncoder;
    private final SpdyHeaderBlockDecoder spdyHeaderBlockDecoder;
    private final SpdyHeaderBlockEncoder spdyHeaderBlockEncoder;
    private SpdyHeadersFrame spdyHeadersFrame;
    private SpdySettingsFrame spdySettingsFrame;
    private ChannelHandlerContext ctx;
    private boolean read;
    private final boolean validateHeaders;

    public SpdyFrameCodec(SpdyVersion spdyVersion) {
        this(spdyVersion, true);
    }

    public SpdyFrameCodec(SpdyVersion spdyVersion, boolean bl2) {
        this(spdyVersion, 8192, 16384, 6, 15, 8, bl2);
    }

    public SpdyFrameCodec(SpdyVersion spdyVersion, int n2, int n3, int n4, int n5, int n6) {
        this(spdyVersion, n2, n3, n4, n5, n6, true);
    }

    public SpdyFrameCodec(SpdyVersion spdyVersion, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this(spdyVersion, n2, SpdyHeaderBlockDecoder.newInstance(spdyVersion, n3), SpdyHeaderBlockEncoder.newInstance(spdyVersion, n4, n5, n6), bl2);
    }

    protected SpdyFrameCodec(SpdyVersion spdyVersion, int n2, SpdyHeaderBlockDecoder spdyHeaderBlockDecoder, SpdyHeaderBlockEncoder spdyHeaderBlockEncoder, boolean bl2) {
        this.spdyFrameDecoder = new SpdyFrameDecoder(spdyVersion, this, n2);
        this.spdyFrameEncoder = new SpdyFrameEncoder(spdyVersion);
        this.spdyHeaderBlockDecoder = spdyHeaderBlockDecoder;
        this.spdyHeaderBlockEncoder = spdyHeaderBlockEncoder;
        this.validateHeaders = bl2;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        this.ctx = channelHandlerContext;
        channelHandlerContext.channel().closeFuture().addListener(new SpdyFrameCodec$1(this));
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.spdyFrameDecoder.decode(byteBuf);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (!this.read && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        this.read = false;
        super.channelReadComplete(channelHandlerContext);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeDataFrame(channelHandlerContext.alloc(), spdyDataFrame.streamId(), spdyDataFrame.isLast(), spdyDataFrame.content());
            spdyDataFrame.release();
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdySynStreamFrame) {
            ByteBuf byteBuf;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)object;
            ByteBuf byteBuf2 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), spdySynStreamFrame);
            try {
                byteBuf = this.spdyFrameEncoder.encodeSynStreamFrame(channelHandlerContext.alloc(), spdySynStreamFrame.streamId(), spdySynStreamFrame.associatedStreamId(), spdySynStreamFrame.priority(), spdySynStreamFrame.isLast(), spdySynStreamFrame.isUnidirectional(), byteBuf2);
            }
            finally {
                byteBuf2.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdySynReplyFrame) {
            ByteBuf byteBuf;
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)object;
            ByteBuf byteBuf3 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), spdySynReplyFrame);
            try {
                byteBuf = this.spdyFrameEncoder.encodeSynReplyFrame(channelHandlerContext.alloc(), spdySynReplyFrame.streamId(), spdySynReplyFrame.isLast(), byteBuf3);
            }
            finally {
                byteBuf3.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeRstStreamFrame(channelHandlerContext.alloc(), spdyRstStreamFrame.streamId(), spdyRstStreamFrame.status().code());
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeSettingsFrame(channelHandlerContext.alloc(), spdySettingsFrame);
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodePingFrame(channelHandlerContext.alloc(), spdyPingFrame.id());
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyGoAwayFrame) {
            SpdyGoAwayFrame spdyGoAwayFrame = (SpdyGoAwayFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeGoAwayFrame(channelHandlerContext.alloc(), spdyGoAwayFrame.lastGoodStreamId(), spdyGoAwayFrame.status().code());
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyHeadersFrame) {
            ByteBuf byteBuf;
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)object;
            ByteBuf byteBuf4 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), spdyHeadersFrame);
            try {
                byteBuf = this.spdyFrameEncoder.encodeHeadersFrame(channelHandlerContext.alloc(), spdyHeadersFrame.streamId(), spdyHeadersFrame.isLast(), byteBuf4);
            }
            finally {
                byteBuf4.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyWindowUpdateFrame) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeWindowUpdateFrame(channelHandlerContext.alloc(), spdyWindowUpdateFrame.streamId(), spdyWindowUpdateFrame.deltaWindowSize());
            channelHandlerContext.write(byteBuf, channelPromise);
        } else {
            throw new UnsupportedMessageTypeException(object, new Class[0]);
        }
    }

    @Override
    public void readDataFrame(int n2, boolean bl2, ByteBuf byteBuf) {
        this.read = true;
        DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n2, byteBuf);
        defaultSpdyDataFrame.setLast(bl2);
        this.ctx.fireChannelRead(defaultSpdyDataFrame);
    }

    @Override
    public void readSynStreamFrame(int n2, int n3, byte by2, boolean bl2, boolean bl3) {
        DefaultSpdySynStreamFrame defaultSpdySynStreamFrame = new DefaultSpdySynStreamFrame(n2, n3, by2, this.validateHeaders);
        defaultSpdySynStreamFrame.setLast(bl2);
        defaultSpdySynStreamFrame.setUnidirectional(bl3);
        this.spdyHeadersFrame = defaultSpdySynStreamFrame;
    }

    @Override
    public void readSynReplyFrame(int n2, boolean bl2) {
        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n2, this.validateHeaders);
        defaultSpdySynReplyFrame.setLast(bl2);
        this.spdyHeadersFrame = defaultSpdySynReplyFrame;
    }

    @Override
    public void readRstStreamFrame(int n2, int n3) {
        this.read = true;
        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n2, n3);
        this.ctx.fireChannelRead(defaultSpdyRstStreamFrame);
    }

    @Override
    public void readSettingsFrame(boolean bl2) {
        this.read = true;
        this.spdySettingsFrame = new DefaultSpdySettingsFrame();
        this.spdySettingsFrame.setClearPreviouslyPersistedSettings(bl2);
    }

    @Override
    public void readSetting(int n2, int n3, boolean bl2, boolean bl3) {
        this.spdySettingsFrame.setValue(n2, n3, bl2, bl3);
    }

    @Override
    public void readSettingsEnd() {
        this.read = true;
        SpdySettingsFrame spdySettingsFrame = this.spdySettingsFrame;
        this.spdySettingsFrame = null;
        this.ctx.fireChannelRead(spdySettingsFrame);
    }

    @Override
    public void readPingFrame(int n2) {
        this.read = true;
        DefaultSpdyPingFrame defaultSpdyPingFrame = new DefaultSpdyPingFrame(n2);
        this.ctx.fireChannelRead(defaultSpdyPingFrame);
    }

    @Override
    public void readGoAwayFrame(int n2, int n3) {
        this.read = true;
        DefaultSpdyGoAwayFrame defaultSpdyGoAwayFrame = new DefaultSpdyGoAwayFrame(n2, n3);
        this.ctx.fireChannelRead(defaultSpdyGoAwayFrame);
    }

    @Override
    public void readHeadersFrame(int n2, boolean bl2) {
        this.spdyHeadersFrame = new DefaultSpdyHeadersFrame(n2, this.validateHeaders);
        this.spdyHeadersFrame.setLast(bl2);
    }

    @Override
    public void readWindowUpdateFrame(int n2, int n3) {
        this.read = true;
        DefaultSpdyWindowUpdateFrame defaultSpdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(n2, n3);
        this.ctx.fireChannelRead(defaultSpdyWindowUpdateFrame);
    }

    @Override
    public void readHeaderBlock(ByteBuf byteBuf) {
        try {
            this.spdyHeaderBlockDecoder.decode(this.ctx.alloc(), byteBuf, this.spdyHeadersFrame);
        }
        catch (Exception exception) {
            this.ctx.fireExceptionCaught(exception);
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void readHeaderBlockEnd() {
        SpdyHeadersFrame spdyHeadersFrame = null;
        try {
            this.spdyHeaderBlockDecoder.endHeaderBlock(this.spdyHeadersFrame);
            spdyHeadersFrame = this.spdyHeadersFrame;
            this.spdyHeadersFrame = null;
        }
        catch (Exception exception) {
            this.ctx.fireExceptionCaught(exception);
        }
        if (spdyHeadersFrame != null) {
            this.read = true;
            this.ctx.fireChannelRead(spdyHeadersFrame);
        }
    }

    @Override
    public void readFrameError(String string) {
        this.ctx.fireExceptionCaught(INVALID_FRAME);
    }

    static /* synthetic */ SpdyHeaderBlockDecoder access$000(SpdyFrameCodec spdyFrameCodec) {
        return spdyFrameCodec.spdyHeaderBlockDecoder;
    }

    static /* synthetic */ SpdyHeaderBlockEncoder access$100(SpdyFrameCodec spdyFrameCodec) {
        return spdyFrameCodec.spdyHeaderBlockEncoder;
    }
}

