/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.util.internal.StringUtil;

public class DefaultSpdySynStreamFrame
extends DefaultSpdyHeadersFrame
implements SpdySynStreamFrame {
    private int associatedStreamId;
    private byte priority;
    private boolean unidirectional;

    public DefaultSpdySynStreamFrame(int n2, int n3, byte by2) {
        this(n2, n3, by2, true);
    }

    public DefaultSpdySynStreamFrame(int n2, int n3, byte by2, boolean bl2) {
        super(n2, bl2);
        this.setAssociatedStreamId(n3);
        this.setPriority(by2);
    }

    @Override
    public SpdySynStreamFrame setStreamId(int n2) {
        super.setStreamId(n2);
        return this;
    }

    @Override
    public SpdySynStreamFrame setLast(boolean bl2) {
        super.setLast(bl2);
        return this;
    }

    @Override
    public SpdySynStreamFrame setInvalid() {
        super.setInvalid();
        return this;
    }

    @Override
    public int associatedStreamId() {
        return this.associatedStreamId;
    }

    @Override
    public SpdySynStreamFrame setAssociatedStreamId(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Associated-To-Stream-ID cannot be negative: " + n2);
        }
        this.associatedStreamId = n2;
        return this;
    }

    @Override
    public byte priority() {
        return this.priority;
    }

    @Override
    public SpdySynStreamFrame setPriority(byte by2) {
        if (by2 < 0 || by2 > 7) {
            throw new IllegalArgumentException("Priority must be between 0 and 7 inclusive: " + by2);
        }
        this.priority = by2;
        return this;
    }

    @Override
    public boolean isUnidirectional() {
        return this.unidirectional;
    }

    @Override
    public SpdySynStreamFrame setUnidirectional(boolean bl2) {
        this.unidirectional = bl2;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(last: ").append(this.isLast()).append("; unidirectional: ").append(this.isUnidirectional()).append(')').append(StringUtil.NEWLINE).append("--> Stream-ID = ").append(this.streamId()).append(StringUtil.NEWLINE);
        if (this.associatedStreamId != 0) {
            stringBuilder.append("--> Associated-To-Stream-ID = ").append(this.associatedStreamId()).append(StringUtil.NEWLINE);
        }
        stringBuilder.append("--> Priority = ").append(this.priority()).append(StringUtil.NEWLINE).append("--> Headers:").append(StringUtil.NEWLINE);
        this.appendHeaders(stringBuilder);
        stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
        return stringBuilder.toString();
    }
}

