/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.DefaultSpdyHeaders;
import io.netty.handler.codec.spdy.DefaultSpdyStreamFrame;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.util.internal.StringUtil;
import java.util.Map;

public class DefaultSpdyHeadersFrame
extends DefaultSpdyStreamFrame
implements SpdyHeadersFrame {
    private boolean invalid;
    private boolean truncated;
    private final SpdyHeaders headers;

    public DefaultSpdyHeadersFrame(int n2) {
        this(n2, true);
    }

    public DefaultSpdyHeadersFrame(int n2, boolean bl2) {
        super(n2);
        this.headers = new DefaultSpdyHeaders(bl2);
    }

    @Override
    public SpdyHeadersFrame setStreamId(int n2) {
        super.setStreamId(n2);
        return this;
    }

    @Override
    public SpdyHeadersFrame setLast(boolean bl2) {
        super.setLast(bl2);
        return this;
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public SpdyHeadersFrame setInvalid() {
        this.invalid = true;
        return this;
    }

    @Override
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public SpdyHeadersFrame setTruncated() {
        this.truncated = true;
        return this;
    }

    @Override
    public SpdyHeaders headers() {
        return this.headers;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(last: ").append(this.isLast()).append(')').append(StringUtil.NEWLINE).append("--> Stream-ID = ").append(this.streamId()).append(StringUtil.NEWLINE).append("--> Headers:").append(StringUtil.NEWLINE);
        this.appendHeaders(stringBuilder);
        stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
        return stringBuilder.toString();
    }

    protected void appendHeaders(StringBuilder stringBuilder) {
        for (Map.Entry entry : this.headers()) {
            stringBuilder.append("    ");
            stringBuilder.append((CharSequence)entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append((CharSequence)entry.getValue());
            stringBuilder.append(StringUtil.NEWLINE);
        }
    }
}

