/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthResponseDecoder$State;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import java.util.List;

public class Socks5PasswordAuthResponseDecoder
extends ReplayingDecoder<Socks5PasswordAuthResponseDecoder$State> {
    public Socks5PasswordAuthResponseDecoder() {
        super(Socks5PasswordAuthResponseDecoder$State.INIT);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks5PasswordAuthResponseDecoder$State)((Object)this.state())) {
                case INIT: {
                    int n2 = byteBuf.readByte();
                    if (n2 != 1) {
                        throw new DecoderException("unsupported subnegotiation version: " + n2 + " (expected: 1)");
                    }
                    list.add(new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.valueOf(byteBuf.readByte())));
                    this.checkpoint(Socks5PasswordAuthResponseDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n2 = this.actualReadableBytes();
                    if (n2 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n2));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        this.checkpoint(Socks5PasswordAuthResponseDecoder$State.FAILURE);
        DefaultSocks5PasswordAuthResponse defaultSocks5PasswordAuthResponse = new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE);
        defaultSocks5PasswordAuthResponse.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks5PasswordAuthResponse);
    }
}

