/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder$State;
import io.netty.util.CharsetUtil;
import java.util.List;

public class Socks5PasswordAuthRequestDecoder
extends ReplayingDecoder<Socks5PasswordAuthRequestDecoder$State> {
    public Socks5PasswordAuthRequestDecoder() {
        super(Socks5PasswordAuthRequestDecoder$State.INIT);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks5PasswordAuthRequestDecoder$State)((Object)this.state())) {
                case INIT: {
                    int n2 = byteBuf.readerIndex();
                    byte by2 = byteBuf.getByte(n2);
                    if (by2 != 1) {
                        throw new DecoderException("unsupported subnegotiation version: " + by2 + " (expected: 1)");
                    }
                    short s2 = byteBuf.getUnsignedByte(n2 + 1);
                    short s3 = byteBuf.getUnsignedByte(n2 + 2 + s2);
                    int n3 = s2 + s3 + 3;
                    byteBuf.skipBytes(n3);
                    list.add(new DefaultSocks5PasswordAuthRequest(byteBuf.toString(n2 + 2, s2, CharsetUtil.US_ASCII), byteBuf.toString(n2 + 3 + s2, s3, CharsetUtil.US_ASCII)));
                    this.checkpoint(Socks5PasswordAuthRequestDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n2 = this.actualReadableBytes();
                    if (n2 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n2));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        this.checkpoint(Socks5PasswordAuthRequestDecoder$State.FAILURE);
        DefaultSocks5PasswordAuthRequest defaultSocks5PasswordAuthRequest = new DefaultSocks5PasswordAuthRequest("", "");
        defaultSocks5PasswordAuthRequest.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks5PasswordAuthRequest);
    }
}

