/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.SocksVersion;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialRequest;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder$State;
import java.util.List;

public class Socks5InitialRequestDecoder
extends ReplayingDecoder<Socks5InitialRequestDecoder$State> {
    public Socks5InitialRequestDecoder() {
        super(Socks5InitialRequestDecoder$State.INIT);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks5InitialRequestDecoder$State)((Object)this.state())) {
                case INIT: {
                    int n2 = byteBuf.readByte();
                    if (n2 != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + n2 + " (expected: " + SocksVersion.SOCKS5.byteValue() + ')');
                    }
                    int n3 = byteBuf.readUnsignedByte();
                    if (this.actualReadableBytes() < n3) break;
                    Socks5AuthMethod[] socks5AuthMethodArray = new Socks5AuthMethod[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        socks5AuthMethodArray[i2] = Socks5AuthMethod.valueOf(byteBuf.readByte());
                    }
                    list.add(new DefaultSocks5InitialRequest(socks5AuthMethodArray));
                    this.checkpoint(Socks5InitialRequestDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n2 = this.actualReadableBytes();
                    if (n2 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n2));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        this.checkpoint(Socks5InitialRequestDecoder$State.FAILURE);
        DefaultSocks5InitialRequest defaultSocks5InitialRequest = new DefaultSocks5InitialRequest(Socks5AuthMethod.NO_AUTH);
        defaultSocks5InitialRequest.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks5InitialRequest);
    }
}

