/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.socksx.v5.Socks5AddressEncoder;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;

final class Socks5AddressEncoder$1
implements Socks5AddressEncoder {
    Socks5AddressEncoder$1() {
    }

    @Override
    public void encodeAddress(Socks5AddressType socks5AddressType, String string, ByteBuf byteBuf) {
        byte by2 = socks5AddressType.byteValue();
        if (by2 == Socks5AddressType.IPv4.byteValue()) {
            if (string != null) {
                byteBuf.writeBytes(NetUtil.createByteArrayFromIpAddressString(string));
            } else {
                byteBuf.writeInt(0);
            }
        } else if (by2 == Socks5AddressType.DOMAIN.byteValue()) {
            if (string != null) {
                byteBuf.writeByte(string.length());
                byteBuf.writeCharSequence(string, CharsetUtil.US_ASCII);
            } else {
                byteBuf.writeByte(1);
                byteBuf.writeByte(0);
            }
        } else if (by2 == Socks5AddressType.IPv6.byteValue()) {
            if (string != null) {
                byteBuf.writeBytes(NetUtil.createByteArrayFromIpAddressString(string));
            } else {
                byteBuf.writeLong(0L);
                byteBuf.writeLong(0L);
            }
        } else {
            throw new EncoderException("unsupported addrType: " + (socks5AddressType.byteValue() & 0xFF));
        }
    }
}

