/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.socksx.v5.Socks5AddressDecoder;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;

final class Socks5AddressDecoder$1
implements Socks5AddressDecoder {
    private static final int IPv6_LEN = 16;

    Socks5AddressDecoder$1() {
    }

    @Override
    public String decodeAddress(Socks5AddressType socks5AddressType, ByteBuf byteBuf) {
        if (socks5AddressType == Socks5AddressType.IPv4) {
            return NetUtil.intToIpAddress(byteBuf.readInt());
        }
        if (socks5AddressType == Socks5AddressType.DOMAIN) {
            short s2 = byteBuf.readUnsignedByte();
            String string = byteBuf.toString(byteBuf.readerIndex(), s2, CharsetUtil.US_ASCII);
            byteBuf.skipBytes(s2);
            return string;
        }
        if (socks5AddressType == Socks5AddressType.IPv6) {
            if (byteBuf.hasArray()) {
                int n2 = byteBuf.readerIndex();
                byteBuf.readerIndex(n2 + 16);
                return NetUtil.bytesToIpAddress(byteBuf.array(), byteBuf.arrayOffset() + n2, 16);
            }
            byte[] byArray = new byte[16];
            byteBuf.readBytes(byArray);
            return NetUtil.bytesToIpAddress(byArray);
        }
        throw new DecoderException("unsupported address type: " + (socks5AddressType.byteValue() & 0xFF));
    }
}

