/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import io.netty.handler.codec.socksx.v4.Socks4ClientDecoder$State;
import io.netty.handler.codec.socksx.v4.Socks4CommandStatus;
import io.netty.util.NetUtil;
import java.util.List;

public class Socks4ClientDecoder
extends ReplayingDecoder<Socks4ClientDecoder$State> {
    public Socks4ClientDecoder() {
        super(Socks4ClientDecoder$State.START);
        this.setSingleDecode(true);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks4ClientDecoder$State)((Object)this.state())) {
                case START: {
                    int n2 = byteBuf.readUnsignedByte();
                    if (n2 != 0) {
                        throw new DecoderException("unsupported reply version: " + n2 + " (expected: 0)");
                    }
                    Socks4CommandStatus socks4CommandStatus = Socks4CommandStatus.valueOf(byteBuf.readByte());
                    int n3 = byteBuf.readUnsignedShort();
                    String string = NetUtil.intToIpAddress(byteBuf.readInt());
                    list.add(new DefaultSocks4CommandResponse(socks4CommandStatus, string, n3));
                    this.checkpoint(Socks4ClientDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n2 = this.actualReadableBytes();
                    if (n2 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n2));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        DefaultSocks4CommandResponse defaultSocks4CommandResponse = new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED);
        defaultSocks4CommandResponse.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks4CommandResponse);
        this.checkpoint(Socks4ClientDecoder$State.FAILURE);
    }
}

