/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socks.SocksRequest;
import io.netty.handler.codec.socks.SocksResponse;
import io.netty.handler.codec.socks.UnknownSocksRequest;
import io.netty.handler.codec.socks.UnknownSocksResponse;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;

final class SocksCommonUtils {
    public static final SocksRequest UNKNOWN_SOCKS_REQUEST = new UnknownSocksRequest();
    public static final SocksResponse UNKNOWN_SOCKS_RESPONSE = new UnknownSocksResponse();
    private static final char ipv6hextetSeparator = ':';

    private SocksCommonUtils() {
    }

    public static String ipv6toStr(byte[] byArray) {
        assert (byArray.length == 16);
        StringBuilder stringBuilder = new StringBuilder(39);
        SocksCommonUtils.ipv6toStr(stringBuilder, byArray, 0, 8);
        return stringBuilder.toString();
    }

    private static void ipv6toStr(StringBuilder stringBuilder, byte[] byArray, int n2, int n3) {
        int n4;
        --n3;
        for (n4 = n2; n4 < n3; ++n4) {
            SocksCommonUtils.appendHextet(stringBuilder, byArray, n4);
            stringBuilder.append(':');
        }
        SocksCommonUtils.appendHextet(stringBuilder, byArray, n4);
    }

    private static void appendHextet(StringBuilder stringBuilder, byte[] byArray, int n2) {
        StringUtil.toHexString(stringBuilder, byArray, n2 << 1, 2);
    }

    static String readUsAscii(ByteBuf byteBuf, int n2) {
        String string = byteBuf.toString(byteBuf.readerIndex(), n2, CharsetUtil.US_ASCII);
        byteBuf.skipBytes(n2);
        return string;
    }
}

