/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socks.SocksAddressType;
import io.netty.handler.codec.socks.SocksCmdResponse;
import io.netty.handler.codec.socks.SocksCmdResponseDecoder$State;
import io.netty.handler.codec.socks.SocksCmdStatus;
import io.netty.handler.codec.socks.SocksCommonUtils;
import io.netty.handler.codec.socks.SocksProtocolVersion;
import io.netty.util.NetUtil;
import java.util.List;

public class SocksCmdResponseDecoder
extends ReplayingDecoder<SocksCmdResponseDecoder$State> {
    private SocksCmdStatus cmdStatus;
    private SocksAddressType addressType;

    public SocksCmdResponseDecoder() {
        super(SocksCmdResponseDecoder$State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        block0 : switch ((SocksCmdResponseDecoder$State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                if (byteBuf.readByte() != SocksProtocolVersion.SOCKS5.byteValue()) {
                    list.add(SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE);
                    break;
                }
                this.checkpoint(SocksCmdResponseDecoder$State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdStatus = SocksCmdStatus.valueOf(byteBuf.readByte());
                byteBuf.skipBytes(1);
                this.addressType = SocksAddressType.valueOf(byteBuf.readByte());
                this.checkpoint(SocksCmdResponseDecoder$State.READ_CMD_ADDRESS);
            }
            case READ_CMD_ADDRESS: {
                switch (this.addressType) {
                    case IPv4: {
                        String string = NetUtil.intToIpAddress(byteBuf.readInt());
                        int n2 = byteBuf.readUnsignedShort();
                        list.add(new SocksCmdResponse(this.cmdStatus, this.addressType, string, n2));
                        break block0;
                    }
                    case DOMAIN: {
                        byte by2 = byteBuf.readByte();
                        String string = SocksCommonUtils.readUsAscii(byteBuf, by2);
                        int n3 = byteBuf.readUnsignedShort();
                        list.add(new SocksCmdResponse(this.cmdStatus, this.addressType, string, n3));
                        break block0;
                    }
                    case IPv6: {
                        byte[] byArray = new byte[16];
                        byteBuf.readBytes(byArray);
                        String string = SocksCommonUtils.ipv6toStr(byArray);
                        int n4 = byteBuf.readUnsignedShort();
                        list.add(new SocksCmdResponse(this.cmdStatus, this.addressType, string, n4));
                        break block0;
                    }
                    case UNKNOWN: {
                        list.add(SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE);
                        break block0;
                    }
                }
                throw new Error();
            }
            default: {
                throw new Error();
            }
        }
        channelHandlerContext.pipeline().remove(this);
    }
}

