/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socks.SocksAuthRequest;
import io.netty.handler.codec.socks.SocksAuthRequestDecoder$State;
import io.netty.handler.codec.socks.SocksCommonUtils;
import io.netty.handler.codec.socks.SocksSubnegotiationVersion;
import java.util.List;

public class SocksAuthRequestDecoder
extends ReplayingDecoder<SocksAuthRequestDecoder$State> {
    private String username;

    public SocksAuthRequestDecoder() {
        super(SocksAuthRequestDecoder$State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        switch ((SocksAuthRequestDecoder$State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                if (byteBuf.readByte() != SocksSubnegotiationVersion.AUTH_PASSWORD.byteValue()) {
                    list.add(SocksCommonUtils.UNKNOWN_SOCKS_REQUEST);
                    break;
                }
                this.checkpoint(SocksAuthRequestDecoder$State.READ_USERNAME);
            }
            case READ_USERNAME: {
                byte by2 = byteBuf.readByte();
                this.username = SocksCommonUtils.readUsAscii(byteBuf, by2);
                this.checkpoint(SocksAuthRequestDecoder$State.READ_PASSWORD);
            }
            case READ_PASSWORD: {
                byte by2 = byteBuf.readByte();
                String string = SocksCommonUtils.readUsAscii(byteBuf, by2);
                list.add(new SocksAuthRequest(this.username, string));
                break;
            }
            default: {
                throw new Error();
            }
        }
        channelHandlerContext.pipeline().remove(this);
    }
}

