/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.smtp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.smtp.DefaultSmtpResponse;
import io.netty.handler.codec.smtp.SmtpResponse;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SmtpResponseDecoder
extends LineBasedFrameDecoder {
    private List<CharSequence> details;

    public SmtpResponseDecoder(int n2) {
        super(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SmtpResponse decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = (ByteBuf)super.decode(channelHandlerContext, byteBuf);
        if (byteBuf2 == null) {
            return null;
        }
        try {
            int n2 = byteBuf2.readableBytes();
            int n3 = byteBuf2.readerIndex();
            if (n2 < 3) {
                throw SmtpResponseDecoder.newDecoderException(byteBuf, n3, n2);
            }
            int n4 = SmtpResponseDecoder.parseCode(byteBuf2);
            byte by2 = byteBuf2.readByte();
            String string = byteBuf2.isReadable() ? byteBuf2.toString(CharsetUtil.US_ASCII) : null;
            List<CharSequence> list = this.details;
            switch (by2) {
                case 32: {
                    void var9_12;
                    this.details = null;
                    if (list != null) {
                        if (string != null) {
                            list.add(string);
                        }
                    } else if (string == null) {
                        List list2 = Collections.emptyList();
                    } else {
                        List<String> list3 = Collections.singletonList(string);
                    }
                    DefaultSmtpResponse defaultSmtpResponse = new DefaultSmtpResponse(n4, (List<CharSequence>)var9_12);
                    return defaultSmtpResponse;
                }
                case 45: {
                    void var9_14;
                    if (string == null) return null;
                    if (list == null) {
                        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(4);
                        this.details = arrayList;
                    }
                    var9_14.add(string);
                    return null;
                }
                default: {
                    throw SmtpResponseDecoder.newDecoderException(byteBuf, n3, n2);
                }
            }
        }
        finally {
            byteBuf2.release();
        }
    }

    private static DecoderException newDecoderException(ByteBuf byteBuf, int n2, int n3) {
        return new DecoderException("Received invalid line: '" + byteBuf.toString(n2, n3, CharsetUtil.US_ASCII) + '\'');
    }

    private static int parseCode(ByteBuf byteBuf) {
        int n2 = SmtpResponseDecoder.parseNumber(byteBuf.readByte()) * 100;
        int n3 = SmtpResponseDecoder.parseNumber(byteBuf.readByte()) * 10;
        int n4 = SmtpResponseDecoder.parseNumber(byteBuf.readByte());
        return n2 + n3 + n4;
    }

    private static int parseNumber(byte by2) {
        return Character.digit((char)by2, 10);
    }
}

