/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.smtp;

import io.netty.handler.codec.smtp.SmtpResponse;
import io.netty.handler.codec.smtp.SmtpUtils;
import java.util.Collections;
import java.util.List;

public final class DefaultSmtpResponse
implements SmtpResponse {
    private final int code;
    private final List<CharSequence> details;

    public DefaultSmtpResponse(int n2) {
        this(n2, (List<CharSequence>)null);
    }

    public DefaultSmtpResponse(int n2, CharSequence ... charSequenceArray) {
        this(n2, SmtpUtils.toUnmodifiableList(charSequenceArray));
    }

    DefaultSmtpResponse(int n2, List<CharSequence> list) {
        if (n2 < 100 || n2 > 599) {
            throw new IllegalArgumentException("code must be 100 <= code <= 599");
        }
        this.code = n2;
        this.details = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public List<CharSequence> details() {
        return this.details;
    }

    public int hashCode() {
        return this.code * 31 + this.details.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultSmtpResponse)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        DefaultSmtpResponse defaultSmtpResponse = (DefaultSmtpResponse)object;
        return this.code() == defaultSmtpResponse.code() && this.details().equals(defaultSmtpResponse.details());
    }

    public String toString() {
        return "DefaultSmtpResponse{code=" + this.code + ", details=" + this.details + '}';
    }
}

