/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.serialization.CompactObjectOutputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class ObjectEncoderOutputStream
extends OutputStream
implements ObjectOutput {
    private final DataOutputStream out;
    private final int estimatedLength;

    public ObjectEncoderOutputStream(OutputStream outputStream) {
        this(outputStream, 512);
    }

    public ObjectEncoderOutputStream(OutputStream outputStream, int n2) {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("estimatedLength: " + n2);
        }
        this.out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.estimatedLength = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object object) {
        ByteBuf byteBuf = Unpooled.buffer(this.estimatedLength);
        try {
            CompactObjectOutputStream compactObjectOutputStream = new CompactObjectOutputStream(new ByteBufOutputStream(byteBuf));
            try {
                compactObjectOutputStream.writeObject(object);
                compactObjectOutputStream.flush();
            }
            finally {
                compactObjectOutputStream.close();
            }
            int n2 = byteBuf.readableBytes();
            this.writeInt(n2);
            byteBuf.getBytes(0, this, n2);
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void write(int n2) {
        this.out.write(n2);
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    public final int size() {
        return this.out.size();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.out.write(byArray, n2, n3);
    }

    @Override
    public void write(byte[] byArray) {
        this.out.write(byArray);
    }

    @Override
    public final void writeBoolean(boolean bl2) {
        this.out.writeBoolean(bl2);
    }

    @Override
    public final void writeByte(int n2) {
        this.out.writeByte(n2);
    }

    @Override
    public final void writeBytes(String string) {
        this.out.writeBytes(string);
    }

    @Override
    public final void writeChar(int n2) {
        this.out.writeChar(n2);
    }

    @Override
    public final void writeChars(String string) {
        this.out.writeChars(string);
    }

    @Override
    public final void writeDouble(double d2) {
        this.out.writeDouble(d2);
    }

    @Override
    public final void writeFloat(float f2) {
        this.out.writeFloat(f2);
    }

    @Override
    public final void writeInt(int n2) {
        this.out.writeInt(n2);
    }

    @Override
    public final void writeLong(long l2) {
        this.out.writeLong(l2);
    }

    @Override
    public final void writeShort(int n2) {
        this.out.writeShort(n2);
    }

    @Override
    public final void writeUTF(String string) {
        this.out.writeUTF(string);
    }
}

