/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.sctp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.sctp.SctpMessage;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SctpMessageCompletionHandler
extends MessageToMessageDecoder<SctpMessage> {
    private final Map<Integer, ByteBuf> fragments = new HashMap<Integer, ByteBuf>();

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, SctpMessage sctpMessage, List<Object> list) {
        ByteBuf byteBuf = sctpMessage.content();
        int n2 = sctpMessage.protocolIdentifier();
        int n3 = sctpMessage.streamIdentifier();
        boolean bl2 = sctpMessage.isComplete();
        boolean bl3 = sctpMessage.isUnordered();
        ByteBuf byteBuf2 = this.fragments.remove(n3);
        if (byteBuf2 == null) {
            byteBuf2 = Unpooled.EMPTY_BUFFER;
        }
        if (bl2 && !byteBuf2.isReadable()) {
            list.add(sctpMessage);
        } else if (!bl2 && byteBuf2.isReadable()) {
            this.fragments.put(n3, Unpooled.wrappedBuffer(byteBuf2, byteBuf));
        } else if (bl2 && byteBuf2.isReadable()) {
            SctpMessage sctpMessage2 = new SctpMessage(n2, n3, bl3, Unpooled.wrappedBuffer(byteBuf2, byteBuf));
            list.add(sctpMessage2);
        } else {
            this.fragments.put(n3, byteBuf);
        }
        byteBuf.retain();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        for (ByteBuf byteBuf : this.fragments.values()) {
            byteBuf.release();
        }
        this.fragments.clear();
        super.handlerRemoved(channelHandlerContext);
    }
}

