/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.redis.ArrayHeaderRedisMessage;
import io.netty.handler.codec.redis.BulkStringHeaderRedisMessage;
import io.netty.handler.codec.redis.DefaultBulkStringRedisContent;
import io.netty.handler.codec.redis.DefaultLastBulkStringRedisContent;
import io.netty.handler.codec.redis.ErrorRedisMessage;
import io.netty.handler.codec.redis.FixedRedisMessagePool;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.InlineCommandRedisMessage;
import io.netty.handler.codec.redis.IntegerRedisMessage;
import io.netty.handler.codec.redis.RedisCodecException;
import io.netty.handler.codec.redis.RedisCodecUtil;
import io.netty.handler.codec.redis.RedisConstants;
import io.netty.handler.codec.redis.RedisDecoder$State;
import io.netty.handler.codec.redis.RedisDecoder$ToPositiveLongProcessor;
import io.netty.handler.codec.redis.RedisMessage;
import io.netty.handler.codec.redis.RedisMessagePool;
import io.netty.handler.codec.redis.RedisMessageType;
import io.netty.handler.codec.redis.SimpleStringRedisMessage;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import java.util.List;

public final class RedisDecoder
extends ByteToMessageDecoder {
    private final RedisDecoder$ToPositiveLongProcessor toPositiveLongProcessor = new RedisDecoder$ToPositiveLongProcessor();
    private final boolean decodeInlineCommands;
    private final int maxInlineMessageLength;
    private final RedisMessagePool messagePool;
    private RedisDecoder$State state = RedisDecoder$State.DECODE_TYPE;
    private RedisMessageType type;
    private int remainingBulkLength;

    public RedisDecoder() {
        this(false);
    }

    public RedisDecoder(boolean bl2) {
        this(65536, FixedRedisMessagePool.INSTANCE, bl2);
    }

    public RedisDecoder(int n2, RedisMessagePool redisMessagePool) {
        this(n2, redisMessagePool, false);
    }

    public RedisDecoder(int n2, RedisMessagePool redisMessagePool, boolean bl2) {
        if (n2 <= 0 || n2 > 0x20000000) {
            throw new RedisCodecException("maxInlineMessageLength: " + n2 + " (expected: <= " + 0x20000000 + ")");
        }
        this.maxInlineMessageLength = n2;
        this.messagePool = redisMessagePool;
        this.decodeInlineCommands = bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            block10: while (true) {
                switch (this.state) {
                    case DECODE_TYPE: {
                        if (this.decodeType(byteBuf)) continue block10;
                        return;
                    }
                    case DECODE_INLINE: {
                        if (this.decodeInline(byteBuf, list)) continue block10;
                        return;
                    }
                    case DECODE_LENGTH: {
                        if (this.decodeLength(byteBuf, list)) continue block10;
                        return;
                    }
                    case DECODE_BULK_STRING_EOL: {
                        if (this.decodeBulkStringEndOfLine(byteBuf, list)) continue block10;
                        return;
                    }
                    case DECODE_BULK_STRING_CONTENT: {
                        if (!this.decodeBulkStringContent(byteBuf, list)) return;
                        continue block10;
                    }
                }
                break;
            }
            throw new RedisCodecException("Unknown state: " + (Object)((Object)this.state));
        }
        catch (RedisCodecException redisCodecException) {
            this.resetDecoder();
            throw redisCodecException;
        }
        catch (Exception exception) {
            this.resetDecoder();
            throw new RedisCodecException(exception);
        }
    }

    private void resetDecoder() {
        this.state = RedisDecoder$State.DECODE_TYPE;
        this.remainingBulkLength = 0;
    }

    private boolean decodeType(ByteBuf byteBuf) {
        if (!byteBuf.isReadable()) {
            return false;
        }
        this.type = RedisMessageType.readFrom(byteBuf, this.decodeInlineCommands);
        this.state = this.type.isInline() ? RedisDecoder$State.DECODE_INLINE : RedisDecoder$State.DECODE_LENGTH;
        return true;
    }

    private boolean decodeInline(ByteBuf byteBuf, List<Object> list) {
        ByteBuf byteBuf2 = RedisDecoder.readLine(byteBuf);
        if (byteBuf2 == null) {
            if (byteBuf.readableBytes() > this.maxInlineMessageLength) {
                throw new RedisCodecException("length: " + byteBuf.readableBytes() + " (expected: <= " + this.maxInlineMessageLength + ")");
            }
            return false;
        }
        list.add(this.newInlineRedisMessage(this.type, byteBuf2));
        this.resetDecoder();
        return true;
    }

    private boolean decodeLength(ByteBuf byteBuf, List<Object> list) {
        ByteBuf byteBuf2 = RedisDecoder.readLine(byteBuf);
        if (byteBuf2 == null) {
            return false;
        }
        long l2 = this.parseRedisNumber(byteBuf2);
        if (l2 < -1L) {
            throw new RedisCodecException("length: " + l2 + " (expected: >= " + -1 + ")");
        }
        switch (this.type) {
            case ARRAY_HEADER: {
                list.add(new ArrayHeaderRedisMessage(l2));
                this.resetDecoder();
                return true;
            }
            case BULK_STRING: {
                if (l2 > 0x20000000L) {
                    throw new RedisCodecException("length: " + l2 + " (expected: <= " + 0x20000000 + ")");
                }
                this.remainingBulkLength = (int)l2;
                return this.decodeBulkString(byteBuf, list);
            }
        }
        throw new RedisCodecException("bad type: " + (Object)((Object)this.type));
    }

    private boolean decodeBulkString(ByteBuf byteBuf, List<Object> list) {
        switch (this.remainingBulkLength) {
            case -1: {
                list.add(FullBulkStringRedisMessage.NULL_INSTANCE);
                this.resetDecoder();
                return true;
            }
            case 0: {
                this.state = RedisDecoder$State.DECODE_BULK_STRING_EOL;
                return this.decodeBulkStringEndOfLine(byteBuf, list);
            }
        }
        list.add(new BulkStringHeaderRedisMessage(this.remainingBulkLength));
        this.state = RedisDecoder$State.DECODE_BULK_STRING_CONTENT;
        return this.decodeBulkStringContent(byteBuf, list);
    }

    private boolean decodeBulkStringEndOfLine(ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.readableBytes() < 2) {
            return false;
        }
        RedisDecoder.readEndOfLine(byteBuf);
        list.add(FullBulkStringRedisMessage.EMPTY_INSTANCE);
        this.resetDecoder();
        return true;
    }

    private boolean decodeBulkStringContent(ByteBuf byteBuf, List<Object> list) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0 || this.remainingBulkLength == 0 && n2 < 2) {
            return false;
        }
        if (n2 >= this.remainingBulkLength + 2) {
            ByteBuf byteBuf2 = byteBuf.readSlice(this.remainingBulkLength);
            RedisDecoder.readEndOfLine(byteBuf);
            list.add(new DefaultLastBulkStringRedisContent(byteBuf2.retain()));
            this.resetDecoder();
            return true;
        }
        int n3 = Math.min(this.remainingBulkLength, n2);
        this.remainingBulkLength -= n3;
        list.add(new DefaultBulkStringRedisContent(byteBuf.readSlice(n3).retain()));
        return true;
    }

    private static void readEndOfLine(ByteBuf byteBuf) {
        short s2 = byteBuf.readShort();
        if (RedisConstants.EOL_SHORT == s2) {
            return;
        }
        byte[] byArray = RedisCodecUtil.shortToBytes(s2);
        throw new RedisCodecException("delimiter: [" + byArray[0] + "," + byArray[1] + "] (expected: \\r\\n)");
    }

    private RedisMessage newInlineRedisMessage(RedisMessageType redisMessageType, ByteBuf byteBuf) {
        switch (redisMessageType) {
            case INLINE_COMMAND: {
                return new InlineCommandRedisMessage(byteBuf.toString(CharsetUtil.UTF_8));
            }
            case SIMPLE_STRING: {
                SimpleStringRedisMessage simpleStringRedisMessage = this.messagePool.getSimpleString(byteBuf);
                return simpleStringRedisMessage != null ? simpleStringRedisMessage : new SimpleStringRedisMessage(byteBuf.toString(CharsetUtil.UTF_8));
            }
            case ERROR: {
                ErrorRedisMessage errorRedisMessage = this.messagePool.getError(byteBuf);
                return errorRedisMessage != null ? errorRedisMessage : new ErrorRedisMessage(byteBuf.toString(CharsetUtil.UTF_8));
            }
            case INTEGER: {
                IntegerRedisMessage integerRedisMessage = this.messagePool.getInteger(byteBuf);
                return integerRedisMessage != null ? integerRedisMessage : new IntegerRedisMessage(this.parseRedisNumber(byteBuf));
            }
        }
        throw new RedisCodecException("bad type: " + (Object)((Object)redisMessageType));
    }

    private static ByteBuf readLine(ByteBuf byteBuf) {
        if (!byteBuf.isReadable(2)) {
            return null;
        }
        int n2 = byteBuf.forEachByte(ByteProcessor.FIND_LF);
        if (n2 < 0) {
            return null;
        }
        ByteBuf byteBuf2 = byteBuf.readSlice(n2 - byteBuf.readerIndex() - 1);
        RedisDecoder.readEndOfLine(byteBuf);
        return byteBuf2;
    }

    private long parseRedisNumber(ByteBuf byteBuf) {
        int n2;
        int n3 = byteBuf.readableBytes();
        boolean bl2 = n3 > 0 && byteBuf.getByte(byteBuf.readerIndex()) == 45;
        int n4 = n2 = bl2 ? 1 : 0;
        if (n3 <= n2) {
            throw new RedisCodecException("no number to parse: " + byteBuf.toString(CharsetUtil.US_ASCII));
        }
        if (n3 > 19 + n2) {
            throw new RedisCodecException("too many characters to be a valid RESP Integer: " + byteBuf.toString(CharsetUtil.US_ASCII));
        }
        if (bl2) {
            return -this.parsePositiveNumber(byteBuf.skipBytes(n2));
        }
        return this.parsePositiveNumber(byteBuf);
    }

    private long parsePositiveNumber(ByteBuf byteBuf) {
        this.toPositiveLongProcessor.reset();
        byteBuf.forEachByte(this.toPositiveLongProcessor);
        return this.toPositiveLongProcessor.content();
    }
}

