/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;

final class RedisCodecUtil {
    private RedisCodecUtil() {
    }

    static byte[] longToAsciiBytes(long l2) {
        return Long.toString(l2).getBytes(CharsetUtil.US_ASCII);
    }

    static short makeShort(char c2, char c3) {
        return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)(c3 << 8 | c2) : (short)(c2 << 8 | c3);
    }

    static byte[] shortToBytes(short s2) {
        byte[] byArray = new byte[2];
        if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
            byArray[1] = (byte)(s2 >> 8 & 0xFF);
            byArray[0] = (byte)(s2 & 0xFF);
        } else {
            byArray[0] = (byte)(s2 >> 8 & 0xFF);
            byArray[1] = (byte)(s2 & 0xFF);
        }
        return byArray;
    }
}

