/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageAggregator;
import io.netty.handler.codec.redis.BulkStringHeaderRedisMessage;
import io.netty.handler.codec.redis.BulkStringRedisContent;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.LastBulkStringRedisContent;
import io.netty.handler.codec.redis.RedisMessage;

public final class RedisBulkStringAggregator
extends MessageAggregator<RedisMessage, BulkStringHeaderRedisMessage, BulkStringRedisContent, FullBulkStringRedisMessage> {
    public RedisBulkStringAggregator() {
        super(0x20000000);
    }

    @Override
    protected boolean isStartMessage(RedisMessage redisMessage) {
        return redisMessage instanceof BulkStringHeaderRedisMessage && !this.isAggregated(redisMessage);
    }

    @Override
    protected boolean isContentMessage(RedisMessage redisMessage) {
        return redisMessage instanceof BulkStringRedisContent;
    }

    @Override
    protected boolean isLastContentMessage(BulkStringRedisContent bulkStringRedisContent) {
        return bulkStringRedisContent instanceof LastBulkStringRedisContent;
    }

    @Override
    protected boolean isAggregated(RedisMessage redisMessage) {
        return redisMessage instanceof FullBulkStringRedisMessage;
    }

    @Override
    protected boolean isContentLengthInvalid(BulkStringHeaderRedisMessage bulkStringHeaderRedisMessage, int n2) {
        return bulkStringHeaderRedisMessage.bulkStringLength() > n2;
    }

    @Override
    protected Object newContinueResponse(BulkStringHeaderRedisMessage bulkStringHeaderRedisMessage, int n2, ChannelPipeline channelPipeline) {
        return null;
    }

    @Override
    protected boolean closeAfterContinueResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean ignoreContentAfterContinueResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected FullBulkStringRedisMessage beginAggregation(BulkStringHeaderRedisMessage bulkStringHeaderRedisMessage, ByteBuf byteBuf) {
        return new FullBulkStringRedisMessage(byteBuf);
    }
}

