/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.redis.ArrayHeaderRedisMessage;
import io.netty.handler.codec.redis.ArrayRedisMessage;
import io.netty.handler.codec.redis.RedisArrayAggregator$AggregateState;
import io.netty.handler.codec.redis.RedisMessage;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public final class RedisArrayAggregator
extends MessageToMessageDecoder<RedisMessage> {
    private final Deque<RedisArrayAggregator$AggregateState> depths = new ArrayDeque<RedisArrayAggregator$AggregateState>(4);

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, RedisMessage redisMessage, List<Object> list) {
        if (redisMessage instanceof ArrayHeaderRedisMessage) {
            if ((redisMessage = this.decodeRedisArrayHeader((ArrayHeaderRedisMessage)redisMessage)) == null) {
                return;
            }
        } else {
            ReferenceCountUtil.retain(redisMessage);
        }
        while (!this.depths.isEmpty()) {
            RedisArrayAggregator$AggregateState redisArrayAggregator$AggregateState = this.depths.peek();
            RedisArrayAggregator$AggregateState.access$000(redisArrayAggregator$AggregateState).add(redisMessage);
            if (RedisArrayAggregator$AggregateState.access$000(redisArrayAggregator$AggregateState).size() == RedisArrayAggregator$AggregateState.access$100(redisArrayAggregator$AggregateState)) {
                redisMessage = new ArrayRedisMessage(RedisArrayAggregator$AggregateState.access$000(redisArrayAggregator$AggregateState));
                this.depths.pop();
                continue;
            }
            return;
        }
        list.add(redisMessage);
    }

    private RedisMessage decodeRedisArrayHeader(ArrayHeaderRedisMessage arrayHeaderRedisMessage) {
        if (arrayHeaderRedisMessage.isNull()) {
            return ArrayRedisMessage.NULL_INSTANCE;
        }
        if (arrayHeaderRedisMessage.length() == 0L) {
            return ArrayRedisMessage.EMPTY_INSTANCE;
        }
        if (arrayHeaderRedisMessage.length() > 0L) {
            if (arrayHeaderRedisMessage.length() > Integer.MAX_VALUE) {
                throw new CodecException("this codec doesn't support longer length than 2147483647");
            }
            this.depths.push(new RedisArrayAggregator$AggregateState((int)arrayHeaderRedisMessage.length()));
            return null;
        }
        throw new CodecException("bad length: " + arrayHeaderRedisMessage.length());
    }
}

