/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.handler.codec.redis.ArrayRedisMessage$1;
import io.netty.handler.codec.redis.ArrayRedisMessage$2;
import io.netty.handler.codec.redis.RedisMessage;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Collections;
import java.util.List;

public class ArrayRedisMessage
extends AbstractReferenceCounted
implements RedisMessage {
    private final List<RedisMessage> children;
    public static final ArrayRedisMessage NULL_INSTANCE = new ArrayRedisMessage$1();
    public static final ArrayRedisMessage EMPTY_INSTANCE = new ArrayRedisMessage$2();

    private ArrayRedisMessage() {
        this.children = Collections.emptyList();
    }

    public ArrayRedisMessage(List<RedisMessage> list) {
        this.children = ObjectUtil.checkNotNull(list, "children");
    }

    public final List<RedisMessage> children() {
        return this.children;
    }

    public boolean isNull() {
        return false;
    }

    @Override
    protected void deallocate() {
        for (RedisMessage redisMessage : this.children) {
            ReferenceCountUtil.release(redisMessage);
        }
    }

    @Override
    public ArrayRedisMessage touch(Object object) {
        for (RedisMessage redisMessage : this.children) {
            ReferenceCountUtil.touch(redisMessage);
        }
        return this;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '[' + "children=" + this.children.size() + ']';
    }

    /* synthetic */ ArrayRedisMessage(ArrayRedisMessage$1 var1_1) {
        this();
    }
}

