/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        byteBuf.markReaderIndex();
        int n2 = byteBuf.readerIndex();
        int n3 = ProtobufVarint32FrameDecoder.readRawVarint32(byteBuf);
        if (n2 == byteBuf.readerIndex()) {
            return;
        }
        if (n3 < 0) {
            throw new CorruptedFrameException("negative length: " + n3);
        }
        if (byteBuf.readableBytes() < n3) {
            byteBuf.resetReaderIndex();
        } else {
            list.add(byteBuf.readRetainedSlice(n3));
        }
    }

    private static int readRawVarint32(ByteBuf byteBuf) {
        if (!byteBuf.isReadable()) {
            return 0;
        }
        byteBuf.markReaderIndex();
        byte by2 = byteBuf.readByte();
        if (by2 >= 0) {
            return by2;
        }
        int n2 = by2 & 0x7F;
        if (!byteBuf.isReadable()) {
            byteBuf.resetReaderIndex();
            return 0;
        }
        by2 = byteBuf.readByte();
        if (by2 >= 0) {
            n2 |= by2 << 7;
        } else {
            n2 |= (by2 & 0x7F) << 7;
            if (!byteBuf.isReadable()) {
                byteBuf.resetReaderIndex();
                return 0;
            }
            by2 = byteBuf.readByte();
            if (by2 >= 0) {
                n2 |= by2 << 14;
            } else {
                n2 |= (by2 & 0x7F) << 14;
                if (!byteBuf.isReadable()) {
                    byteBuf.resetReaderIndex();
                    return 0;
                }
                by2 = byteBuf.readByte();
                if (by2 >= 0) {
                    n2 |= by2 << 21;
                } else {
                    n2 |= (by2 & 0x7F) << 21;
                    if (!byteBuf.isReadable()) {
                        byteBuf.resetReaderIndex();
                        return 0;
                    }
                    by2 = byteBuf.readByte();
                    n2 |= by2 << 28;
                    if (by2 < 0) {
                        throw new CorruptedFrameException("malformed varint.");
                    }
                }
            }
        }
        return n2;
    }
}

