/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import com.google.protobuf.nano.MessageNano;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler$Sharable;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler$Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz) {
        this.clazz = ObjectUtil.checkNotNull(clazz, "You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n2;
        byte[] byArray;
        int n3 = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n2 = byteBuf.arrayOffset() + byteBuf.readerIndex();
        } else {
            byArray = new byte[n3];
            byteBuf.getBytes(byteBuf.readerIndex(), byArray, 0, n3);
            n2 = 0;
        }
        MessageNano messageNano = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        list.add(MessageNano.mergeFrom((MessageNano)messageNano, (byte[])byArray, (int)n2, (int)n3));
    }
}

