/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.util.CharsetUtil;

public final class MqttMessageBuilders$ConnectBuilder {
    private MqttVersion version = MqttVersion.MQTT_3_1_1;
    private String clientId;
    private boolean cleanSession;
    private boolean hasUser;
    private boolean hasPassword;
    private int keepAliveSecs;
    private boolean willFlag;
    private boolean willRetain;
    private MqttQoS willQos = MqttQoS.AT_MOST_ONCE;
    private String willTopic;
    private byte[] willMessage;
    private String username;
    private byte[] password;

    MqttMessageBuilders$ConnectBuilder() {
    }

    public MqttMessageBuilders$ConnectBuilder protocolVersion(MqttVersion mqttVersion) {
        this.version = mqttVersion;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder clientId(String string) {
        this.clientId = string;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder cleanSession(boolean bl2) {
        this.cleanSession = bl2;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder keepAlive(int n2) {
        this.keepAliveSecs = n2;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder willFlag(boolean bl2) {
        this.willFlag = bl2;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder willQoS(MqttQoS mqttQoS) {
        this.willQos = mqttQoS;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder willTopic(String string) {
        this.willTopic = string;
        return this;
    }

    @Deprecated
    public MqttMessageBuilders$ConnectBuilder willMessage(String string) {
        this.willMessage(string == null ? null : string.getBytes(CharsetUtil.UTF_8));
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder willMessage(byte[] byArray) {
        this.willMessage = byArray;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder willRetain(boolean bl2) {
        this.willRetain = bl2;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder hasUser(boolean bl2) {
        this.hasUser = bl2;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder hasPassword(boolean bl2) {
        this.hasPassword = bl2;
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder username(String string) {
        this.hasUser = string != null;
        this.username = string;
        return this;
    }

    @Deprecated
    public MqttMessageBuilders$ConnectBuilder password(String string) {
        this.password(string == null ? null : string.getBytes(CharsetUtil.UTF_8));
        return this;
    }

    public MqttMessageBuilders$ConnectBuilder password(byte[] byArray) {
        this.hasPassword = byArray != null;
        this.password = byArray;
        return this;
    }

    public MqttConnectMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.CONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttConnectVariableHeader mqttConnectVariableHeader = new MqttConnectVariableHeader(this.version.protocolName(), this.version.protocolLevel(), this.hasUser, this.hasPassword, this.willRetain, this.willQos.value(), this.willFlag, this.cleanSession, this.keepAliveSecs);
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload(this.clientId, this.willTopic, this.willMessage, this.username, this.password);
        return new MqttConnectMessage(mqttFixedHeader, mqttConnectVariableHeader, mqttConnectPayload);
    }
}

