/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.mqtt.MqttCodecUtil;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttDecoder$DecoderState;
import io.netty.handler.codec.mqtt.MqttDecoder$Result;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttIdentifierRejectedException;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.List;

public final class MqttDecoder
extends ReplayingDecoder<MqttDecoder$DecoderState> {
    private static final int DEFAULT_MAX_BYTES_IN_MESSAGE = 8092;
    private MqttFixedHeader mqttFixedHeader;
    private Object variableHeader;
    private int bytesRemainingInVariablePart;
    private final int maxBytesInMessage;

    public MqttDecoder() {
        this(8092);
    }

    public MqttDecoder(int n2) {
        super(MqttDecoder$DecoderState.READ_FIXED_HEADER);
        this.maxBytesInMessage = n2;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        switch ((MqttDecoder$DecoderState)((Object)this.state())) {
            case READ_FIXED_HEADER: {
                try {
                    this.mqttFixedHeader = MqttDecoder.decodeFixedHeader(byteBuf);
                    this.bytesRemainingInVariablePart = this.mqttFixedHeader.remainingLength();
                    this.checkpoint(MqttDecoder$DecoderState.READ_VARIABLE_HEADER);
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(exception));
                    return;
                }
            }
            case READ_VARIABLE_HEADER: {
                MqttDecoder$Result<?> mqttDecoder$Result;
                try {
                    if (this.bytesRemainingInVariablePart > this.maxBytesInMessage) {
                        throw new DecoderException("too large message: " + this.bytesRemainingInVariablePart + " bytes");
                    }
                    mqttDecoder$Result = MqttDecoder.decodeVariableHeader(byteBuf, this.mqttFixedHeader);
                    this.variableHeader = MqttDecoder$Result.access$000(mqttDecoder$Result);
                    this.bytesRemainingInVariablePart -= MqttDecoder$Result.access$100(mqttDecoder$Result);
                    this.checkpoint(MqttDecoder$DecoderState.READ_PAYLOAD);
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(exception));
                    return;
                }
            }
            case READ_PAYLOAD: {
                MqttDecoder$Result<?> mqttDecoder$Result;
                try {
                    mqttDecoder$Result = MqttDecoder.decodePayload(byteBuf, this.mqttFixedHeader.messageType(), this.bytesRemainingInVariablePart, this.variableHeader);
                    this.bytesRemainingInVariablePart -= MqttDecoder$Result.access$100(mqttDecoder$Result);
                    if (this.bytesRemainingInVariablePart != 0) {
                        throw new DecoderException("non-zero remaining payload bytes: " + this.bytesRemainingInVariablePart + " (" + (Object)((Object)this.mqttFixedHeader.messageType()) + ')');
                    }
                    this.checkpoint(MqttDecoder$DecoderState.READ_FIXED_HEADER);
                    MqttMessage mqttMessage = MqttMessageFactory.newMessage(this.mqttFixedHeader, this.variableHeader, MqttDecoder$Result.access$000(mqttDecoder$Result));
                    this.mqttFixedHeader = null;
                    this.variableHeader = null;
                    list.add(mqttMessage);
                    break;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                byteBuf.skipBytes(this.actualReadableBytes());
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private MqttMessage invalidMessage(Throwable throwable) {
        this.checkpoint(MqttDecoder$DecoderState.BAD_MESSAGE);
        return MqttMessageFactory.newInvalidMessage(throwable);
    }

    private static MqttFixedHeader decodeFixedHeader(ByteBuf byteBuf) {
        short s2;
        short s3 = byteBuf.readUnsignedByte();
        MqttMessageType mqttMessageType = MqttMessageType.valueOf(s3 >> 4);
        boolean bl2 = (s3 & 8) == 8;
        int n2 = (s3 & 6) >> 1;
        boolean bl3 = (s3 & 1) != 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        do {
            s2 = byteBuf.readUnsignedByte();
            n3 += (s2 & 0x7F) * n4;
            n4 *= 128;
        } while ((s2 & 0x80) != 0 && ++n5 < 4);
        if (n5 == 4 && (s2 & 0x80) != 0) {
            throw new DecoderException("remaining length exceeds 4 digits (" + (Object)((Object)mqttMessageType) + ')');
        }
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(mqttMessageType, bl2, MqttQoS.valueOf(n2), bl3, n3);
        return MqttCodecUtil.validateFixedHeader(MqttCodecUtil.resetUnusedFields(mqttFixedHeader));
    }

    private static MqttDecoder$Result<?> decodeVariableHeader(ByteBuf byteBuf, MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return MqttDecoder.decodeConnectionVariableHeader(byteBuf);
            }
            case CONNACK: {
                return MqttDecoder.decodeConnAckVariableHeader(byteBuf);
            }
            case SUBSCRIBE: 
            case UNSUBSCRIBE: 
            case SUBACK: 
            case UNSUBACK: 
            case PUBACK: 
            case PUBREC: 
            case PUBCOMP: 
            case PUBREL: {
                return MqttDecoder.decodeMessageIdVariableHeader(byteBuf);
            }
            case PUBLISH: {
                return MqttDecoder.decodePublishVariableHeader(byteBuf, mqttFixedHeader);
            }
            case PINGREQ: 
            case PINGRESP: 
            case DISCONNECT: {
                return new MqttDecoder$Result<Object>(null, 0);
            }
        }
        return new MqttDecoder$Result<Object>(null, 0);
    }

    private static MqttDecoder$Result<MqttConnectVariableHeader> decodeConnectionVariableHeader(ByteBuf byteBuf) {
        boolean bl2;
        MqttDecoder$Result<String> mqttDecoder$Result = MqttDecoder.decodeString(byteBuf);
        int n2 = MqttDecoder$Result.access$100(mqttDecoder$Result);
        byte by2 = byteBuf.readByte();
        ++n2;
        MqttVersion mqttVersion = MqttVersion.fromProtocolNameAndLevel((String)MqttDecoder$Result.access$000(mqttDecoder$Result), by2);
        short s2 = byteBuf.readUnsignedByte();
        ++n2;
        MqttDecoder$Result<Integer> mqttDecoder$Result2 = MqttDecoder.decodeMsbLsb(byteBuf);
        n2 += MqttDecoder$Result.access$100(mqttDecoder$Result2);
        boolean bl3 = (s2 & 0x80) == 128;
        boolean bl4 = (s2 & 0x40) == 64;
        boolean bl5 = (s2 & 0x20) == 32;
        int n3 = (s2 & 0x18) >> 3;
        boolean bl6 = (s2 & 4) == 4;
        boolean bl7 = bl2 = (s2 & 2) == 2;
        if (mqttVersion == MqttVersion.MQTT_3_1_1) {
            boolean bl8;
            boolean bl9 = bl8 = (s2 & 1) == 0;
            if (!bl8) {
                throw new DecoderException("non-zero reserved flag");
            }
        }
        MqttConnectVariableHeader mqttConnectVariableHeader = new MqttConnectVariableHeader(mqttVersion.protocolName(), mqttVersion.protocolLevel(), bl3, bl4, bl5, n3, bl6, bl2, (Integer)MqttDecoder$Result.access$000(mqttDecoder$Result2));
        return new MqttDecoder$Result<MqttConnectVariableHeader>(mqttConnectVariableHeader, n2);
    }

    private static MqttDecoder$Result<MqttConnAckVariableHeader> decodeConnAckVariableHeader(ByteBuf byteBuf) {
        boolean bl2 = (byteBuf.readUnsignedByte() & 1) == 1;
        byte by2 = byteBuf.readByte();
        int n2 = 2;
        MqttConnAckVariableHeader mqttConnAckVariableHeader = new MqttConnAckVariableHeader(MqttConnectReturnCode.valueOf(by2), bl2);
        return new MqttDecoder$Result<MqttConnAckVariableHeader>(mqttConnAckVariableHeader, 2);
    }

    private static MqttDecoder$Result<MqttMessageIdVariableHeader> decodeMessageIdVariableHeader(ByteBuf byteBuf) {
        MqttDecoder$Result<Integer> mqttDecoder$Result = MqttDecoder.decodeMessageId(byteBuf);
        return new MqttDecoder$Result<MqttMessageIdVariableHeader>(MqttMessageIdVariableHeader.from((Integer)MqttDecoder$Result.access$000(mqttDecoder$Result)), MqttDecoder$Result.access$100(mqttDecoder$Result));
    }

    private static MqttDecoder$Result<MqttPublishVariableHeader> decodePublishVariableHeader(ByteBuf byteBuf, MqttFixedHeader mqttFixedHeader) {
        Object object;
        MqttDecoder$Result<String> mqttDecoder$Result = MqttDecoder.decodeString(byteBuf);
        if (!MqttCodecUtil.isValidPublishTopicName((String)MqttDecoder$Result.access$000(mqttDecoder$Result))) {
            throw new DecoderException("invalid publish topic name: " + (String)MqttDecoder$Result.access$000(mqttDecoder$Result) + " (contains wildcards)");
        }
        int n2 = MqttDecoder$Result.access$100(mqttDecoder$Result);
        int n3 = -1;
        if (mqttFixedHeader.qosLevel().value() > 0) {
            object = MqttDecoder.decodeMessageId(byteBuf);
            n3 = (Integer)MqttDecoder$Result.access$000(object);
            n2 += MqttDecoder$Result.access$100((MqttDecoder$Result)object);
        }
        object = new MqttPublishVariableHeader((String)MqttDecoder$Result.access$000(mqttDecoder$Result), n3);
        return new MqttDecoder$Result<Object>(object, n2);
    }

    private static MqttDecoder$Result<Integer> decodeMessageId(ByteBuf byteBuf) {
        MqttDecoder$Result<Integer> mqttDecoder$Result = MqttDecoder.decodeMsbLsb(byteBuf);
        if (!MqttCodecUtil.isValidMessageId((Integer)MqttDecoder$Result.access$000(mqttDecoder$Result))) {
            throw new DecoderException("invalid messageId: " + MqttDecoder$Result.access$000(mqttDecoder$Result));
        }
        return mqttDecoder$Result;
    }

    private static MqttDecoder$Result<?> decodePayload(ByteBuf byteBuf, MqttMessageType mqttMessageType, int n2, Object object) {
        switch (mqttMessageType) {
            case CONNECT: {
                return MqttDecoder.decodeConnectionPayload(byteBuf, (MqttConnectVariableHeader)object);
            }
            case SUBSCRIBE: {
                return MqttDecoder.decodeSubscribePayload(byteBuf, n2);
            }
            case SUBACK: {
                return MqttDecoder.decodeSubackPayload(byteBuf, n2);
            }
            case UNSUBSCRIBE: {
                return MqttDecoder.decodeUnsubscribePayload(byteBuf, n2);
            }
            case PUBLISH: {
                return MqttDecoder.decodePublishPayload(byteBuf, n2);
            }
        }
        return new MqttDecoder$Result<Object>(null, 0);
    }

    private static MqttDecoder$Result<MqttConnectPayload> decodeConnectionPayload(ByteBuf byteBuf, MqttConnectVariableHeader mqttConnectVariableHeader) {
        MqttDecoder$Result<String> mqttDecoder$Result = MqttDecoder.decodeString(byteBuf);
        String string = (String)MqttDecoder$Result.access$000(mqttDecoder$Result);
        MqttVersion mqttVersion = MqttVersion.fromProtocolNameAndLevel(mqttConnectVariableHeader.name(), (byte)mqttConnectVariableHeader.version());
        if (!MqttCodecUtil.isValidClientId(mqttVersion, string)) {
            throw new MqttIdentifierRejectedException("invalid clientIdentifier: " + string);
        }
        int n2 = MqttDecoder$Result.access$100(mqttDecoder$Result);
        MqttDecoder$Result<String> mqttDecoder$Result2 = null;
        MqttDecoder$Result<byte[]> mqttDecoder$Result3 = null;
        if (mqttConnectVariableHeader.isWillFlag()) {
            mqttDecoder$Result2 = MqttDecoder.decodeString(byteBuf, 0, Short.MAX_VALUE);
            n2 += MqttDecoder$Result.access$100(mqttDecoder$Result2);
            mqttDecoder$Result3 = MqttDecoder.decodeByteArray(byteBuf);
            n2 += MqttDecoder$Result.access$100(mqttDecoder$Result3);
        }
        MqttDecoder$Result<String> mqttDecoder$Result4 = null;
        MqttDecoder$Result<byte[]> mqttDecoder$Result5 = null;
        if (mqttConnectVariableHeader.hasUserName()) {
            mqttDecoder$Result4 = MqttDecoder.decodeString(byteBuf);
            n2 += MqttDecoder$Result.access$100(mqttDecoder$Result4);
        }
        if (mqttConnectVariableHeader.hasPassword()) {
            mqttDecoder$Result5 = MqttDecoder.decodeByteArray(byteBuf);
            n2 += MqttDecoder$Result.access$100(mqttDecoder$Result5);
        }
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload((String)MqttDecoder$Result.access$000(mqttDecoder$Result), mqttDecoder$Result2 != null ? (String)MqttDecoder$Result.access$000(mqttDecoder$Result2) : null, mqttDecoder$Result3 != null ? (byte[])MqttDecoder$Result.access$000(mqttDecoder$Result3) : null, mqttDecoder$Result4 != null ? (String)MqttDecoder$Result.access$000(mqttDecoder$Result4) : null, mqttDecoder$Result5 != null ? (byte[])MqttDecoder$Result.access$000(mqttDecoder$Result5) : null);
        return new MqttDecoder$Result<MqttConnectPayload>(mqttConnectPayload, n2);
    }

    private static MqttDecoder$Result<MqttSubscribePayload> decodeSubscribePayload(ByteBuf byteBuf, int n2) {
        int n3;
        ArrayList<MqttTopicSubscription> arrayList = new ArrayList<MqttTopicSubscription>();
        for (n3 = 0; n3 < n2; ++n3) {
            MqttDecoder$Result<String> mqttDecoder$Result = MqttDecoder.decodeString(byteBuf);
            n3 += MqttDecoder$Result.access$100(mqttDecoder$Result);
            int n4 = byteBuf.readUnsignedByte() & 3;
            arrayList.add(new MqttTopicSubscription((String)MqttDecoder$Result.access$000(mqttDecoder$Result), MqttQoS.valueOf(n4)));
        }
        return new MqttDecoder$Result<MqttSubscribePayload>(new MqttSubscribePayload(arrayList), n3);
    }

    private static MqttDecoder$Result<MqttSubAckPayload> decodeSubackPayload(ByteBuf byteBuf, int n2) {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = byteBuf.readUnsignedByte();
            if (n4 != MqttQoS.FAILURE.value()) {
                n4 &= 3;
            }
            arrayList.add(n4);
        }
        return new MqttDecoder$Result<MqttSubAckPayload>(new MqttSubAckPayload(arrayList), n3);
    }

    private static MqttDecoder$Result<MqttUnsubscribePayload> decodeUnsubscribePayload(ByteBuf byteBuf, int n2) {
        int n3;
        MqttDecoder$Result<String> mqttDecoder$Result;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n3 = 0; n3 < n2; n3 += MqttDecoder$Result.access$100(mqttDecoder$Result)) {
            mqttDecoder$Result = MqttDecoder.decodeString(byteBuf);
            arrayList.add((String)MqttDecoder$Result.access$000(mqttDecoder$Result));
        }
        return new MqttDecoder$Result<MqttUnsubscribePayload>(new MqttUnsubscribePayload(arrayList), n3);
    }

    private static MqttDecoder$Result<ByteBuf> decodePublishPayload(ByteBuf byteBuf, int n2) {
        ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n2);
        return new MqttDecoder$Result<ByteBuf>(byteBuf2, n2);
    }

    private static MqttDecoder$Result<String> decodeString(ByteBuf byteBuf) {
        return MqttDecoder.decodeString(byteBuf, 0, Integer.MAX_VALUE);
    }

    private static MqttDecoder$Result<String> decodeString(ByteBuf byteBuf, int n2, int n3) {
        MqttDecoder$Result<Integer> mqttDecoder$Result = MqttDecoder.decodeMsbLsb(byteBuf);
        int n4 = (Integer)MqttDecoder$Result.access$000(mqttDecoder$Result);
        int n5 = MqttDecoder$Result.access$100(mqttDecoder$Result);
        if (n4 < n2 || n4 > n3) {
            byteBuf.skipBytes(n4);
            return new MqttDecoder$Result<Object>(null, n5 += n4);
        }
        String string = byteBuf.toString(byteBuf.readerIndex(), n4, CharsetUtil.UTF_8);
        byteBuf.skipBytes(n4);
        return new MqttDecoder$Result<String>(string, n5 += n4);
    }

    private static MqttDecoder$Result<byte[]> decodeByteArray(ByteBuf byteBuf) {
        MqttDecoder$Result<Integer> mqttDecoder$Result = MqttDecoder.decodeMsbLsb(byteBuf);
        int n2 = (Integer)MqttDecoder$Result.access$000(mqttDecoder$Result);
        byte[] byArray = new byte[n2];
        byteBuf.readBytes(byArray);
        return new MqttDecoder$Result<byte[]>(byArray, MqttDecoder$Result.access$100(mqttDecoder$Result) + n2);
    }

    private static MqttDecoder$Result<Integer> decodeMsbLsb(ByteBuf byteBuf) {
        return MqttDecoder.decodeMsbLsb(byteBuf, 0, 65535);
    }

    private static MqttDecoder$Result<Integer> decodeMsbLsb(ByteBuf byteBuf, int n2, int n3) {
        short s2 = byteBuf.readUnsignedByte();
        short s3 = byteBuf.readUnsignedByte();
        int n4 = 2;
        int n5 = s2 << 8 | s3;
        if (n5 < n2 || n5 > n3) {
            n5 = -1;
        }
        return new MqttDecoder$Result<Integer>(n5, 2);
    }
}

