/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.memcache.AbstractMemcacheObjectDecoder;
import io.netty.handler.codec.memcache.DefaultLastMemcacheContent;
import io.netty.handler.codec.memcache.DefaultMemcacheContent;
import io.netty.handler.codec.memcache.LastMemcacheContent;
import io.netty.handler.codec.memcache.MemcacheContent;
import io.netty.handler.codec.memcache.binary.AbstractBinaryMemcacheDecoder$State;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;
import java.util.List;

public abstract class AbstractBinaryMemcacheDecoder<M extends BinaryMemcacheMessage>
extends AbstractMemcacheObjectDecoder {
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    private final int chunkSize;
    private M currentMessage;
    private int alreadyReadChunkSize;
    private AbstractBinaryMemcacheDecoder$State state = AbstractBinaryMemcacheDecoder$State.READ_HEADER;

    protected AbstractBinaryMemcacheDecoder() {
        this(8192);
    }

    protected AbstractBinaryMemcacheDecoder(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("chunkSize must be a positive integer: " + n2);
        }
        this.chunkSize = n2;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        switch (this.state) {
            case READ_HEADER: {
                try {
                    if (byteBuf.readableBytes() < 24) {
                        return;
                    }
                    this.resetDecoder();
                    this.currentMessage = this.decodeHeader(byteBuf);
                    this.state = AbstractBinaryMemcacheDecoder$State.READ_EXTRAS;
                }
                catch (Exception exception) {
                    this.resetDecoder();
                    list.add(this.invalidMessage(exception));
                    return;
                }
            }
            case READ_EXTRAS: {
                int n2;
                try {
                    n2 = this.currentMessage.extrasLength();
                    if (n2 > 0) {
                        if (byteBuf.readableBytes() < n2) {
                            return;
                        }
                        this.currentMessage.setExtras(byteBuf.readRetainedSlice(n2));
                    }
                    this.state = AbstractBinaryMemcacheDecoder$State.READ_KEY;
                }
                catch (Exception exception) {
                    this.resetDecoder();
                    list.add(this.invalidMessage(exception));
                    return;
                }
            }
            case READ_KEY: {
                int n2;
                try {
                    n2 = this.currentMessage.keyLength();
                    if (n2 > 0) {
                        if (byteBuf.readableBytes() < n2) {
                            return;
                        }
                        this.currentMessage.setKey(byteBuf.readRetainedSlice(n2));
                    }
                    list.add(this.currentMessage.retain());
                    this.state = AbstractBinaryMemcacheDecoder$State.READ_CONTENT;
                }
                catch (Exception exception) {
                    this.resetDecoder();
                    list.add(this.invalidMessage(exception));
                    return;
                }
            }
            case READ_CONTENT: {
                int n2;
                try {
                    n2 = this.currentMessage.totalBodyLength() - this.currentMessage.keyLength() - this.currentMessage.extrasLength();
                    int n3 = byteBuf.readableBytes();
                    if (n2 > 0) {
                        int n4;
                        if (n3 == 0) {
                            return;
                        }
                        if (n3 > this.chunkSize) {
                            n3 = this.chunkSize;
                        }
                        if (n3 > (n4 = n2 - this.alreadyReadChunkSize)) {
                            n3 = n4;
                        }
                        ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n3);
                        DefaultMemcacheContent defaultMemcacheContent = (this.alreadyReadChunkSize += n3) >= n2 ? new DefaultLastMemcacheContent(byteBuf2) : new DefaultMemcacheContent(byteBuf2);
                        list.add(defaultMemcacheContent);
                        if (this.alreadyReadChunkSize < n2) {
                            return;
                        }
                    } else {
                        list.add(LastMemcacheContent.EMPTY_LAST_CONTENT);
                    }
                    this.resetDecoder();
                    this.state = AbstractBinaryMemcacheDecoder$State.READ_HEADER;
                    return;
                }
                catch (Exception exception) {
                    this.resetDecoder();
                    list.add(this.invalidChunk(exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                byteBuf.skipBytes(this.actualReadableBytes());
                return;
            }
        }
        throw new Error("Unknown state reached: " + (Object)((Object)this.state));
    }

    private M invalidMessage(Exception exception) {
        this.state = AbstractBinaryMemcacheDecoder$State.BAD_MESSAGE;
        M m2 = this.buildInvalidMessage();
        m2.setDecoderResult(DecoderResult.failure(exception));
        return m2;
    }

    private MemcacheContent invalidChunk(Exception exception) {
        this.state = AbstractBinaryMemcacheDecoder$State.BAD_MESSAGE;
        DefaultLastMemcacheContent defaultLastMemcacheContent = new DefaultLastMemcacheContent(Unpooled.EMPTY_BUFFER);
        defaultLastMemcacheContent.setDecoderResult(DecoderResult.failure(exception));
        return defaultLastMemcacheContent;
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        super.channelInactive(channelHandlerContext);
        this.resetDecoder();
    }

    protected void resetDecoder() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
        }
        this.alreadyReadChunkSize = 0;
    }

    protected abstract M decodeHeader(ByteBuf var1);

    protected abstract M buildInvalidMessage();
}

