/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.memcache.AbstractMemcacheObject;
import io.netty.handler.codec.memcache.MemcacheContent;
import io.netty.util.internal.StringUtil;

public class DefaultMemcacheContent
extends AbstractMemcacheObject
implements MemcacheContent {
    private final ByteBuf content;

    public DefaultMemcacheContent(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("Content cannot be null.");
        }
        this.content = byteBuf;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public MemcacheContent copy() {
        return this.replace(this.content.copy());
    }

    @Override
    public MemcacheContent duplicate() {
        return this.replace(this.content.duplicate());
    }

    @Override
    public MemcacheContent retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    @Override
    public MemcacheContent replace(ByteBuf byteBuf) {
        return new DefaultMemcacheContent(byteBuf);
    }

    @Override
    public MemcacheContent retain() {
        super.retain();
        return this;
    }

    @Override
    public MemcacheContent retain(int n2) {
        super.retain(n2);
        return this;
    }

    @Override
    public MemcacheContent touch() {
        super.touch();
        return this;
    }

    @Override
    public MemcacheContent touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    protected void deallocate() {
        this.content.release();
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(data: " + this.content() + ", decoderResult: " + this.decoderResult() + ')';
    }
}

