/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.handler.codec.marshalling.LimitingByteInput$TooBigObjectException;
import org.jboss.marshalling.ByteInput;

class LimitingByteInput
implements ByteInput {
    private static final LimitingByteInput$TooBigObjectException EXCEPTION = new LimitingByteInput$TooBigObjectException();
    private final ByteInput input;
    private final long limit;
    private long read;

    LimitingByteInput(ByteInput byteInput, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("The limit MUST be > 0");
        }
        this.input = byteInput;
        this.limit = l2;
    }

    public void close() {
    }

    public int available() {
        return this.readable(this.input.available());
    }

    public int read() {
        int n2 = this.readable(1);
        if (n2 > 0) {
            int n3 = this.input.read();
            ++this.read;
            return n3;
        }
        throw EXCEPTION;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.readable(n3);
        if (n4 > 0) {
            int n5 = this.input.read(byArray, n2, n4);
            this.read += (long)n5;
            return n5;
        }
        throw EXCEPTION;
    }

    public long skip(long l2) {
        int n2 = this.readable((int)l2);
        if (n2 > 0) {
            long l3 = this.input.skip((long)n2);
            this.read += l3;
            return l3;
        }
        throw EXCEPTION;
    }

    private int readable(int n2) {
        return (int)Math.min((long)n2, this.limit - this.read);
    }
}

