/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.json;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class JsonObjectDecoder
extends ByteToMessageDecoder {
    private static final int ST_CORRUPTED = -1;
    private static final int ST_INIT = 0;
    private static final int ST_DECODING_NORMAL = 1;
    private static final int ST_DECODING_ARRAY_STREAM = 2;
    private int openBraces;
    private int idx;
    private int lastReaderIndex;
    private int state;
    private boolean insideString;
    private final int maxObjectLength;
    private final boolean streamArrayElements;

    public JsonObjectDecoder() {
        this(0x100000);
    }

    public JsonObjectDecoder(int n2) {
        this(n2, false);
    }

    public JsonObjectDecoder(boolean bl2) {
        this(0x100000, bl2);
    }

    public JsonObjectDecoder(int n2, boolean bl2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("maxObjectLength must be a positive int");
        }
        this.maxObjectLength = n2;
        this.streamArrayElements = bl2;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n2;
        int n3;
        if (this.state == -1) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        if (this.idx > byteBuf.readerIndex() && this.lastReaderIndex != byteBuf.readerIndex()) {
            this.idx = byteBuf.readerIndex() + (this.idx - this.lastReaderIndex);
        }
        if ((n3 = byteBuf.writerIndex()) > this.maxObjectLength) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            this.reset();
            throw new TooLongFrameException("object length exceeds " + this.maxObjectLength + ": " + n3 + " bytes discarded");
        }
        for (n2 = this.idx; n2 < n3; ++n2) {
            byte by2 = byteBuf.getByte(n2);
            if (this.state == 1) {
                this.decodeByte(by2, byteBuf, n2);
                if (this.openBraces != 0) continue;
                ByteBuf byteBuf2 = this.extractObject(channelHandlerContext, byteBuf, byteBuf.readerIndex(), n2 + 1 - byteBuf.readerIndex());
                if (byteBuf2 != null) {
                    list.add(byteBuf2);
                }
                byteBuf.readerIndex(n2 + 1);
                this.reset();
                continue;
            }
            if (this.state == 2) {
                this.decodeByte(by2, byteBuf, n2);
                if (this.insideString || (this.openBraces != 1 || by2 != 44) && (this.openBraces != 0 || by2 != 93)) continue;
                int n4 = byteBuf.readerIndex();
                while (Character.isWhitespace(byteBuf.getByte(n4))) {
                    byteBuf.skipBytes(1);
                    ++n4;
                }
                for (n4 = n2 - 1; n4 >= byteBuf.readerIndex() && Character.isWhitespace(byteBuf.getByte(n4)); --n4) {
                }
                ByteBuf byteBuf3 = this.extractObject(channelHandlerContext, byteBuf, byteBuf.readerIndex(), n4 + 1 - byteBuf.readerIndex());
                if (byteBuf3 != null) {
                    list.add(byteBuf3);
                }
                byteBuf.readerIndex(n2 + 1);
                if (by2 != 93) continue;
                this.reset();
                continue;
            }
            if (by2 == 123 || by2 == 91) {
                this.initDecoding(by2);
                if (this.state != 2) continue;
                byteBuf.skipBytes(1);
                continue;
            }
            if (Character.isWhitespace(by2)) {
                byteBuf.skipBytes(1);
                continue;
            }
            this.state = -1;
            throw new CorruptedFrameException("invalid JSON received at byte position " + n2 + ": " + ByteBufUtil.hexDump(byteBuf));
        }
        this.idx = byteBuf.readableBytes() == 0 ? 0 : n2;
        this.lastReaderIndex = byteBuf.readerIndex();
    }

    protected ByteBuf extractObject(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.retainedSlice(n2, n3);
    }

    private void decodeByte(byte by2, ByteBuf byteBuf, int n2) {
        if (!(by2 != 123 && by2 != 91 || this.insideString)) {
            ++this.openBraces;
        } else if (!(by2 != 125 && by2 != 93 || this.insideString)) {
            --this.openBraces;
        } else if (by2 == 34) {
            if (!this.insideString) {
                this.insideString = true;
            } else {
                int n3 = 0;
                --n2;
                while (n2 >= 0 && byteBuf.getByte(n2) == 92) {
                    ++n3;
                    --n2;
                }
                if (n3 % 2 == 0) {
                    this.insideString = false;
                }
            }
        }
    }

    private void initDecoding(byte by2) {
        this.openBraces = 1;
        this.state = by2 == 91 && this.streamArrayElements ? 2 : 1;
    }

    private void reset() {
        this.insideString = false;
        this.state = 0;
        this.openBraces = 0;
    }
}

