/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.StreamByteDistributor$StreamState;
import io.netty.handler.codec.http2.StreamByteDistributor$Writer;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$1;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$ParentChangedEvent;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$State;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$StateOnlyComparator;
import io.netty.util.collection.IntCollections;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.EmptyPriorityQueue;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.List;

public final class WeightedFairQueueByteDistributor
implements StreamByteDistributor {
    static final int INITIAL_CHILDREN_MAP_SIZE = Math.max(1, SystemPropertyUtil.getInt("io.netty.http2.childrenMapSize", 2));
    private static final int DEFAULT_MAX_STATE_ONLY_SIZE = 5;
    private final Http2Connection.PropertyKey stateKey;
    private final IntObjectMap<WeightedFairQueueByteDistributor$State> stateOnlyMap;
    private final PriorityQueue<WeightedFairQueueByteDistributor$State> stateOnlyRemovalQueue;
    private final Http2Connection connection;
    private final WeightedFairQueueByteDistributor$State connectionState;
    private int allocationQuantum = 1024;
    private final int maxStateOnlySize;

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection) {
        this(http2Connection, 5);
    }

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maxStateOnlySize: " + n2 + " (expected: >0)");
        }
        if (n2 == 0) {
            this.stateOnlyMap = IntCollections.emptyMap();
            this.stateOnlyRemovalQueue = EmptyPriorityQueue.instance();
        } else {
            this.stateOnlyMap = new IntObjectHashMap<WeightedFairQueueByteDistributor$State>(n2);
            this.stateOnlyRemovalQueue = new DefaultPriorityQueue<WeightedFairQueueByteDistributor$State>(WeightedFairQueueByteDistributor$StateOnlyComparator.INSTANCE, n2 + 2);
        }
        this.maxStateOnlySize = n2;
        this.connection = http2Connection;
        this.stateKey = http2Connection.newKey();
        Http2Stream http2Stream = http2Connection.connectionStream();
        this.connectionState = new WeightedFairQueueByteDistributor$State(this, http2Stream, 16);
        http2Stream.setProperty(this.stateKey, this.connectionState);
        http2Connection.addListener(new WeightedFairQueueByteDistributor$1(this));
    }

    @Override
    public void updateStreamableBytes(StreamByteDistributor$StreamState streamByteDistributor$StreamState) {
        this.state(streamByteDistributor$StreamState.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(streamByteDistributor$StreamState), streamByteDistributor$StreamState.hasFrame() && streamByteDistributor$StreamState.windowSize() >= 0);
    }

    @Override
    public void updateDependencyTree(int n2, int n3, short s2, boolean bl2) {
        ArrayList<WeightedFairQueueByteDistributor$ParentChangedEvent> arrayList;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State2 = this.state(n2);
        if (weightedFairQueueByteDistributor$State2 == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            weightedFairQueueByteDistributor$State2 = new WeightedFairQueueByteDistributor$State(this, n2);
            this.stateOnlyRemovalQueue.add(weightedFairQueueByteDistributor$State2);
            this.stateOnlyMap.put(n2, weightedFairQueueByteDistributor$State2);
        }
        if ((weightedFairQueueByteDistributor$State = this.state(n3)) == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            weightedFairQueueByteDistributor$State = new WeightedFairQueueByteDistributor$State(this, n3);
            this.stateOnlyRemovalQueue.add(weightedFairQueueByteDistributor$State);
            this.stateOnlyMap.put(n3, weightedFairQueueByteDistributor$State);
            arrayList = new ArrayList(1);
            this.connectionState.takeChild(weightedFairQueueByteDistributor$State, false, arrayList);
            this.notifyParentChanged(arrayList);
        }
        if (weightedFairQueueByteDistributor$State2.activeCountForTree != 0 && weightedFairQueueByteDistributor$State2.parent != null) {
            weightedFairQueueByteDistributor$State2.parent.totalQueuedWeights += (long)(s2 - weightedFairQueueByteDistributor$State2.weight);
        }
        weightedFairQueueByteDistributor$State2.weight = s2;
        if (weightedFairQueueByteDistributor$State != weightedFairQueueByteDistributor$State2.parent || bl2 && weightedFairQueueByteDistributor$State.children.size() != 1) {
            if (weightedFairQueueByteDistributor$State.isDescendantOf(weightedFairQueueByteDistributor$State2)) {
                arrayList = new ArrayList(2 + (bl2 ? weightedFairQueueByteDistributor$State.children.size() : 0));
                weightedFairQueueByteDistributor$State2.parent.takeChild(weightedFairQueueByteDistributor$State, false, arrayList);
            } else {
                arrayList = new ArrayList<WeightedFairQueueByteDistributor$ParentChangedEvent>(1 + (bl2 ? weightedFairQueueByteDistributor$State.children.size() : 0));
            }
            weightedFairQueueByteDistributor$State.takeChild(weightedFairQueueByteDistributor$State2, bl2, arrayList);
            this.notifyParentChanged(arrayList);
        }
        while (this.stateOnlyRemovalQueue.size() > this.maxStateOnlySize) {
            arrayList = (WeightedFairQueueByteDistributor$State)this.stateOnlyRemovalQueue.poll();
            ((WeightedFairQueueByteDistributor$State)((Object)arrayList)).parent.removeChild((WeightedFairQueueByteDistributor$State)((Object)arrayList));
            this.stateOnlyMap.remove(((WeightedFairQueueByteDistributor$State)((Object)arrayList)).streamId);
        }
    }

    @Override
    public boolean distribute(int n2, StreamByteDistributor$Writer streamByteDistributor$Writer) {
        int n3;
        if (this.connectionState.activeCountForTree == 0) {
            return false;
        }
        do {
            n3 = this.connectionState.activeCountForTree;
            n2 -= this.distributeToChildren(n2, streamByteDistributor$Writer, this.connectionState);
        } while (this.connectionState.activeCountForTree != 0 && (n2 > 0 || n3 != this.connectionState.activeCountForTree));
        return this.connectionState.activeCountForTree != 0;
    }

    public void allocationQuantum(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("allocationQuantum must be > 0");
        }
        this.allocationQuantum = n2;
    }

    private int distribute(int n2, StreamByteDistributor$Writer streamByteDistributor$Writer, WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        if (weightedFairQueueByteDistributor$State.isActive()) {
            int n3 = Math.min(n2, weightedFairQueueByteDistributor$State.streamableBytes);
            weightedFairQueueByteDistributor$State.write(n3, streamByteDistributor$Writer);
            if (n3 == 0 && n2 != 0) {
                weightedFairQueueByteDistributor$State.updateStreamableBytes(weightedFairQueueByteDistributor$State.streamableBytes, false);
            }
            return n3;
        }
        return this.distributeToChildren(n2, streamByteDistributor$Writer, weightedFairQueueByteDistributor$State);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int distributeToChildren(int n2, StreamByteDistributor$Writer streamByteDistributor$Writer, WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        long l2 = weightedFairQueueByteDistributor$State.totalQueuedWeights;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State2 = weightedFairQueueByteDistributor$State.pollPseudoTimeQueue();
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State3 = weightedFairQueueByteDistributor$State.peekPseudoTimeQueue();
        weightedFairQueueByteDistributor$State2.setDistributing();
        try {
            assert (weightedFairQueueByteDistributor$State3 == null || weightedFairQueueByteDistributor$State3.pseudoTimeToWrite >= weightedFairQueueByteDistributor$State2.pseudoTimeToWrite) : "nextChildState[" + weightedFairQueueByteDistributor$State3.streamId + "].pseudoTime(" + weightedFairQueueByteDistributor$State3.pseudoTimeToWrite + ") <  childState[" + weightedFairQueueByteDistributor$State2.streamId + "].pseudoTime(" + weightedFairQueueByteDistributor$State2.pseudoTimeToWrite + ")";
            int n3 = this.distribute(weightedFairQueueByteDistributor$State3 == null ? n2 : Math.min(n2, (int)Math.min((weightedFairQueueByteDistributor$State3.pseudoTimeToWrite - weightedFairQueueByteDistributor$State2.pseudoTimeToWrite) * (long)weightedFairQueueByteDistributor$State2.weight / l2 + (long)this.allocationQuantum, Integer.MAX_VALUE)), streamByteDistributor$Writer, weightedFairQueueByteDistributor$State2);
            weightedFairQueueByteDistributor$State.pseudoTime += (long)n3;
            weightedFairQueueByteDistributor$State2.updatePseudoTime(weightedFairQueueByteDistributor$State, n3, l2);
            int n4 = n3;
            return n4;
        }
        finally {
            weightedFairQueueByteDistributor$State2.unsetDistributing();
            if (weightedFairQueueByteDistributor$State2.activeCountForTree != 0) {
                weightedFairQueueByteDistributor$State.offerPseudoTimeQueue(weightedFairQueueByteDistributor$State2);
            }
        }
    }

    private WeightedFairQueueByteDistributor$State state(Http2Stream http2Stream) {
        return (WeightedFairQueueByteDistributor$State)http2Stream.getProperty(this.stateKey);
    }

    private WeightedFairQueueByteDistributor$State state(int n2) {
        Http2Stream http2Stream = this.connection.stream(n2);
        return http2Stream != null ? this.state(http2Stream) : this.stateOnlyMap.get(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isChild(int n2, int n3, short s2) {
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State = this.state(n3);
        if (!weightedFairQueueByteDistributor$State.children.containsKey(n2)) return false;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State2 = this.state(n2);
        if (weightedFairQueueByteDistributor$State2.parent != weightedFairQueueByteDistributor$State) return false;
        if (weightedFairQueueByteDistributor$State2.weight != s2) return false;
        return true;
    }

    int numChildren(int n2) {
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State = this.state(n2);
        return weightedFairQueueByteDistributor$State == null ? 0 : weightedFairQueueByteDistributor$State.children.size();
    }

    void notifyParentChanged(List<WeightedFairQueueByteDistributor$ParentChangedEvent> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            WeightedFairQueueByteDistributor$ParentChangedEvent weightedFairQueueByteDistributor$ParentChangedEvent = list.get(i2);
            this.stateOnlyRemovalQueue.priorityChanged(weightedFairQueueByteDistributor$ParentChangedEvent.state);
            if (weightedFairQueueByteDistributor$ParentChangedEvent.state.parent == null || weightedFairQueueByteDistributor$ParentChangedEvent.state.activeCountForTree == 0) continue;
            weightedFairQueueByteDistributor$ParentChangedEvent.state.parent.offerAndInitializePseudoTime(weightedFairQueueByteDistributor$ParentChangedEvent.state);
            weightedFairQueueByteDistributor$ParentChangedEvent.state.parent.activeCountChangeForTree(weightedFairQueueByteDistributor$ParentChangedEvent.state.activeCountForTree);
        }
    }

    static /* synthetic */ IntObjectMap access$000(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.stateOnlyMap;
    }

    static /* synthetic */ WeightedFairQueueByteDistributor$State access$100(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.connectionState;
    }

    static /* synthetic */ PriorityQueue access$200(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.stateOnlyRemovalQueue;
    }

    static /* synthetic */ Http2Connection.PropertyKey access$300(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.stateKey;
    }

    static /* synthetic */ WeightedFairQueueByteDistributor$State access$400(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor, Http2Stream http2Stream) {
        return weightedFairQueueByteDistributor.state(http2Stream);
    }

    static /* synthetic */ int access$500(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.maxStateOnlySize;
    }
}

