/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor$Writer;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$ParentChangedEvent;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$StatePseudoTimeComparator;
import io.netty.util.collection.IntCollections;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.collection.IntObjectMap$PrimitiveEntry;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class WeightedFairQueueByteDistributor$State
implements PriorityQueueNode {
    private static final byte STATE_IS_ACTIVE = 1;
    private static final byte STATE_IS_DISTRIBUTING = 2;
    private static final byte STATE_STREAM_ACTIVATED = 4;
    Http2Stream stream;
    WeightedFairQueueByteDistributor$State parent;
    IntObjectMap<WeightedFairQueueByteDistributor$State> children = IntCollections.emptyMap();
    private final PriorityQueue<WeightedFairQueueByteDistributor$State> pseudoTimeQueue;
    final int streamId;
    int streamableBytes;
    int dependencyTreeDepth;
    int activeCountForTree;
    private int pseudoTimeQueueIndex = -1;
    private int stateOnlyQueueIndex = -1;
    long pseudoTimeToWrite;
    long pseudoTime;
    long totalQueuedWeights;
    private byte flags;
    short weight = (short)16;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ WeightedFairQueueByteDistributor this$0;

    WeightedFairQueueByteDistributor$State(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor, int n2) {
        this(weightedFairQueueByteDistributor, n2, null, 0);
    }

    WeightedFairQueueByteDistributor$State(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor, Http2Stream http2Stream) {
        this(weightedFairQueueByteDistributor, http2Stream, 0);
    }

    WeightedFairQueueByteDistributor$State(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor, Http2Stream http2Stream, int n2) {
        this(weightedFairQueueByteDistributor, http2Stream.id(), http2Stream, n2);
    }

    WeightedFairQueueByteDistributor$State(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor, int n2, Http2Stream http2Stream, int n3) {
        this.this$0 = weightedFairQueueByteDistributor;
        this.stream = http2Stream;
        this.streamId = n2;
        this.pseudoTimeQueue = new DefaultPriorityQueue<WeightedFairQueueByteDistributor$State>(WeightedFairQueueByteDistributor$StatePseudoTimeComparator.INSTANCE, n3);
    }

    boolean isDescendantOf(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State2 = this.parent;
        while (weightedFairQueueByteDistributor$State2 != null) {
            if (weightedFairQueueByteDistributor$State2 == weightedFairQueueByteDistributor$State) {
                return true;
            }
            weightedFairQueueByteDistributor$State2 = weightedFairQueueByteDistributor$State2.parent;
        }
        return false;
    }

    void takeChild(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State, boolean bl2, List<WeightedFairQueueByteDistributor$ParentChangedEvent> list) {
        this.takeChild(null, weightedFairQueueByteDistributor$State, bl2, list);
    }

    void takeChild(Iterator<IntObjectMap$PrimitiveEntry<WeightedFairQueueByteDistributor$State>> iterator, WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State, boolean bl2, List<WeightedFairQueueByteDistributor$ParentChangedEvent> list) {
        Object object;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State2 = weightedFairQueueByteDistributor$State.parent;
        if (weightedFairQueueByteDistributor$State2 != this) {
            list.add(new WeightedFairQueueByteDistributor$ParentChangedEvent(weightedFairQueueByteDistributor$State, weightedFairQueueByteDistributor$State2));
            weightedFairQueueByteDistributor$State.setParent(this);
            if (iterator != null) {
                iterator.remove();
            } else if (weightedFairQueueByteDistributor$State2 != null) {
                weightedFairQueueByteDistributor$State2.children.remove(weightedFairQueueByteDistributor$State.streamId);
            }
            this.initChildrenIfEmpty();
            object = this.children.put(weightedFairQueueByteDistributor$State.streamId, weightedFairQueueByteDistributor$State);
            if (!$assertionsDisabled && object != null) {
                throw new AssertionError((Object)"A stream with the same stream ID was already in the child map.");
            }
        }
        if (bl2 && !this.children.isEmpty()) {
            object = this.removeAllChildrenExcept(weightedFairQueueByteDistributor$State).entries().iterator();
            while (object.hasNext()) {
                weightedFairQueueByteDistributor$State.takeChild((Iterator<IntObjectMap$PrimitiveEntry<WeightedFairQueueByteDistributor$State>>)object, object.next().value(), false, list);
            }
        }
    }

    void removeChild(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        if (this.children.remove(weightedFairQueueByteDistributor$State.streamId) != null) {
            ArrayList<WeightedFairQueueByteDistributor$ParentChangedEvent> arrayList = new ArrayList<WeightedFairQueueByteDistributor$ParentChangedEvent>(1 + weightedFairQueueByteDistributor$State.children.size());
            arrayList.add(new WeightedFairQueueByteDistributor$ParentChangedEvent(weightedFairQueueByteDistributor$State, weightedFairQueueByteDistributor$State.parent));
            weightedFairQueueByteDistributor$State.setParent(null);
            Iterator<IntObjectMap$PrimitiveEntry<WeightedFairQueueByteDistributor$State>> iterator = weightedFairQueueByteDistributor$State.children.entries().iterator();
            while (iterator.hasNext()) {
                this.takeChild(iterator, iterator.next().value(), false, arrayList);
            }
            this.this$0.notifyParentChanged(arrayList);
        }
    }

    private IntObjectMap<WeightedFairQueueByteDistributor$State> removeAllChildrenExcept(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        weightedFairQueueByteDistributor$State = this.children.remove(weightedFairQueueByteDistributor$State.streamId);
        IntObjectMap<WeightedFairQueueByteDistributor$State> intObjectMap = this.children;
        this.initChildren();
        if (weightedFairQueueByteDistributor$State != null) {
            this.children.put(weightedFairQueueByteDistributor$State.streamId, weightedFairQueueByteDistributor$State);
        }
        return intObjectMap;
    }

    private void setParent(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        if (this.activeCountForTree != 0 && this.parent != null) {
            this.parent.removePseudoTimeQueue(this);
            this.parent.activeCountChangeForTree(-this.activeCountForTree);
        }
        this.parent = weightedFairQueueByteDistributor$State;
        this.dependencyTreeDepth = weightedFairQueueByteDistributor$State == null ? Integer.MAX_VALUE : weightedFairQueueByteDistributor$State.dependencyTreeDepth + 1;
    }

    private void initChildrenIfEmpty() {
        if (this.children == IntCollections.emptyMap()) {
            this.initChildren();
        }
    }

    private void initChildren() {
        this.children = new IntObjectHashMap<WeightedFairQueueByteDistributor$State>(WeightedFairQueueByteDistributor.INITIAL_CHILDREN_MAP_SIZE);
    }

    void write(int n2, StreamByteDistributor$Writer streamByteDistributor$Writer) {
        if (!$assertionsDisabled && this.stream == null) {
            throw new AssertionError();
        }
        try {
            streamByteDistributor$Writer.write(this.stream, n2);
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "byte distribution write error", new Object[0]);
        }
    }

    void activeCountChangeForTree(int n2) {
        if (!$assertionsDisabled && this.activeCountForTree + n2 < 0) {
            throw new AssertionError();
        }
        this.activeCountForTree += n2;
        if (this.parent != null) {
            if (!$assertionsDisabled && this.activeCountForTree == n2 && this.pseudoTimeQueueIndex != -1 && !this.parent.pseudoTimeQueue.containsTyped(this)) {
                throw new AssertionError((Object)("State[" + this.streamId + "].activeCountForTree changed from 0 to " + n2 + " is in a pseudoTimeQueue, but not in parent[ " + this.parent.streamId + "]'s pseudoTimeQueue"));
            }
            if (this.activeCountForTree == 0) {
                this.parent.removePseudoTimeQueue(this);
            } else if (this.activeCountForTree == n2 && !this.isDistributing()) {
                this.parent.offerAndInitializePseudoTime(this);
            }
            this.parent.activeCountChangeForTree(n2);
        }
    }

    void updateStreamableBytes(int n2, boolean bl2) {
        if (this.isActive() != bl2) {
            if (bl2) {
                this.activeCountChangeForTree(1);
                this.setActive();
            } else {
                this.activeCountChangeForTree(-1);
                this.unsetActive();
            }
        }
        this.streamableBytes = n2;
    }

    void updatePseudoTime(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State, int n2, long l2) {
        if (!($assertionsDisabled || this.streamId != 0 && n2 >= 0)) {
            throw new AssertionError();
        }
        this.pseudoTimeToWrite = Math.min(this.pseudoTimeToWrite, weightedFairQueueByteDistributor$State.pseudoTime) + (long)n2 * l2 / (long)this.weight;
    }

    void offerAndInitializePseudoTime(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        weightedFairQueueByteDistributor$State.pseudoTimeToWrite = this.pseudoTime;
        this.offerPseudoTimeQueue(weightedFairQueueByteDistributor$State);
    }

    void offerPseudoTimeQueue(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        this.pseudoTimeQueue.offer(weightedFairQueueByteDistributor$State);
        this.totalQueuedWeights += (long)weightedFairQueueByteDistributor$State.weight;
    }

    WeightedFairQueueByteDistributor$State pollPseudoTimeQueue() {
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State = (WeightedFairQueueByteDistributor$State)this.pseudoTimeQueue.poll();
        this.totalQueuedWeights -= (long)weightedFairQueueByteDistributor$State.weight;
        return weightedFairQueueByteDistributor$State;
    }

    void removePseudoTimeQueue(WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        if (this.pseudoTimeQueue.removeTyped(weightedFairQueueByteDistributor$State)) {
            this.totalQueuedWeights -= (long)weightedFairQueueByteDistributor$State.weight;
        }
    }

    WeightedFairQueueByteDistributor$State peekPseudoTimeQueue() {
        return (WeightedFairQueueByteDistributor$State)this.pseudoTimeQueue.peek();
    }

    void close() {
        this.updateStreamableBytes(0, false);
        this.stream = null;
    }

    boolean wasStreamReservedOrActivated() {
        return (this.flags & 4) != 0;
    }

    void setStreamReservedOrActivated() {
        this.flags = (byte)(this.flags | 4);
    }

    boolean isActive() {
        return (this.flags & 1) != 0;
    }

    private void setActive() {
        this.flags = (byte)(this.flags | 1);
    }

    private void unsetActive() {
        this.flags = (byte)(this.flags & 0xFFFFFFFE);
    }

    boolean isDistributing() {
        return (this.flags & 2) != 0;
    }

    void setDistributing() {
        this.flags = (byte)(this.flags | 2);
    }

    void unsetDistributing() {
        this.flags = (byte)(this.flags & 0xFFFFFFFD);
    }

    @Override
    public int priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue) {
        return defaultPriorityQueue == WeightedFairQueueByteDistributor.access$200(this.this$0) ? this.stateOnlyQueueIndex : this.pseudoTimeQueueIndex;
    }

    @Override
    public void priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue, int n2) {
        if (defaultPriorityQueue == WeightedFairQueueByteDistributor.access$200(this.this$0)) {
            this.stateOnlyQueueIndex = n2;
        } else {
            this.pseudoTimeQueueIndex = n2;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256 * (this.activeCountForTree > 0 ? this.activeCountForTree : 1));
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    private void toString(StringBuilder stringBuilder) {
        stringBuilder.append("{streamId ").append(this.streamId).append(" streamableBytes ").append(this.streamableBytes).append(" activeCountForTree ").append(this.activeCountForTree).append(" pseudoTimeQueueIndex ").append(this.pseudoTimeQueueIndex).append(" pseudoTimeToWrite ").append(this.pseudoTimeToWrite).append(" pseudoTime ").append(this.pseudoTime).append(" flags ").append(this.flags).append(" pseudoTimeQueue.size() ").append(this.pseudoTimeQueue.size()).append(" stateOnlyQueueIndex ").append(this.stateOnlyQueueIndex).append(" parent.streamId ").append(this.parent == null ? -1 : this.parent.streamId).append("} [");
        if (!this.pseudoTimeQueue.isEmpty()) {
            for (WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State : this.pseudoTimeQueue) {
                weightedFairQueueByteDistributor$State.toString(stringBuilder);
                stringBuilder.append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(']');
    }

    static {
        $assertionsDisabled = !WeightedFairQueueByteDistributor.class.desiredAssertionStatus();
    }
}

