/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.StreamByteDistributor$StreamState;
import io.netty.handler.codec.http2.StreamByteDistributor$Writer;
import io.netty.handler.codec.http2.UniformStreamByteDistributor$1;
import io.netty.handler.codec.http2.UniformStreamByteDistributor$State;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Deque;

public final class UniformStreamByteDistributor
implements StreamByteDistributor {
    private final Http2Connection$PropertyKey stateKey;
    private final Deque<UniformStreamByteDistributor$State> queue = new ArrayDeque<UniformStreamByteDistributor$State>(4);
    private int minAllocationChunk = 1024;
    private long totalStreamableBytes;

    public UniformStreamByteDistributor(Http2Connection http2Connection) {
        this.stateKey = http2Connection.newKey();
        Http2Stream http2Stream = http2Connection.connectionStream();
        http2Stream.setProperty(this.stateKey, new UniformStreamByteDistributor$State(this, http2Stream));
        http2Connection.addListener(new UniformStreamByteDistributor$1(this));
    }

    public void minAllocationChunk(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("minAllocationChunk must be > 0");
        }
        this.minAllocationChunk = n2;
    }

    @Override
    public void updateStreamableBytes(StreamByteDistributor$StreamState streamByteDistributor$StreamState) {
        this.state(streamByteDistributor$StreamState.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(streamByteDistributor$StreamState), streamByteDistributor$StreamState.hasFrame(), streamByteDistributor$StreamState.windowSize());
    }

    @Override
    public void updateDependencyTree(int n2, int n3, short s2, boolean bl2) {
    }

    @Override
    public boolean distribute(int n2, StreamByteDistributor$Writer streamByteDistributor$Writer) {
        int n3 = this.queue.size();
        if (n3 == 0) {
            return this.totalStreamableBytes > 0L;
        }
        int n4 = Math.max(this.minAllocationChunk, n2 / n3);
        UniformStreamByteDistributor$State uniformStreamByteDistributor$State = this.queue.pollFirst();
        do {
            uniformStreamByteDistributor$State.enqueued = false;
            if (uniformStreamByteDistributor$State.windowNegative) continue;
            if (n2 == 0 && uniformStreamByteDistributor$State.streamableBytes > 0) {
                this.queue.addFirst(uniformStreamByteDistributor$State);
                uniformStreamByteDistributor$State.enqueued = true;
                break;
            }
            int n5 = Math.min(n4, Math.min(n2, uniformStreamByteDistributor$State.streamableBytes));
            n2 -= n5;
            uniformStreamByteDistributor$State.write(n5, streamByteDistributor$Writer);
        } while ((uniformStreamByteDistributor$State = this.queue.pollFirst()) != null);
        return this.totalStreamableBytes > 0L;
    }

    private UniformStreamByteDistributor$State state(Http2Stream http2Stream) {
        return (UniformStreamByteDistributor$State)ObjectUtil.checkNotNull(http2Stream, "stream").getProperty(this.stateKey);
    }

    static /* synthetic */ Http2Connection$PropertyKey access$000(UniformStreamByteDistributor uniformStreamByteDistributor) {
        return uniformStreamByteDistributor.stateKey;
    }

    static /* synthetic */ UniformStreamByteDistributor$State access$100(UniformStreamByteDistributor uniformStreamByteDistributor, Http2Stream http2Stream) {
        return uniformStreamByteDistributor.state(http2Stream);
    }

    static /* synthetic */ long access$200(UniformStreamByteDistributor uniformStreamByteDistributor) {
        return uniformStreamByteDistributor.totalStreamableBytes;
    }

    static /* synthetic */ long access$202(UniformStreamByteDistributor uniformStreamByteDistributor, long l2) {
        uniformStreamByteDistributor.totalStreamableBytes = l2;
        return uniformStreamByteDistributor.totalStreamableBytes;
    }

    static /* synthetic */ Deque access$300(UniformStreamByteDistributor uniformStreamByteDistributor) {
        return uniformStreamByteDistributor.queue;
    }
}

