/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Headers$PseudoHeaderName;
import io.netty.handler.codec.http2.ReadOnlyHttp2Headers$ReadOnlyIterator;
import io.netty.handler.codec.http2.ReadOnlyHttp2Headers$ReadOnlyValueIterator;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReadOnlyHttp2Headers
implements Http2Headers {
    private static final byte PSEUDO_HEADER_TOKEN = 58;
    private final AsciiString[] pseudoHeaders;
    private final AsciiString[] otherHeaders;

    public static ReadOnlyHttp2Headers trailers(boolean bl2, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl2, EmptyArrays.EMPTY_ASCII_STRINGS, asciiStringArray);
    }

    public static ReadOnlyHttp2Headers clientHeaders(boolean bl2, AsciiString asciiString, AsciiString asciiString2, AsciiString asciiString3, AsciiString asciiString4, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl2, new AsciiString[]{Http2Headers$PseudoHeaderName.METHOD.value(), asciiString, Http2Headers$PseudoHeaderName.PATH.value(), asciiString2, Http2Headers$PseudoHeaderName.SCHEME.value(), asciiString3, Http2Headers$PseudoHeaderName.AUTHORITY.value(), asciiString4}, asciiStringArray);
    }

    public static ReadOnlyHttp2Headers serverHeaders(boolean bl2, AsciiString asciiString, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl2, new AsciiString[]{Http2Headers$PseudoHeaderName.STATUS.value(), asciiString}, asciiStringArray);
    }

    private ReadOnlyHttp2Headers(boolean bl2, AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        assert ((asciiStringArray.length & 1) == 0);
        if ((asciiStringArray2.length & 1) != 0) {
            throw ReadOnlyHttp2Headers.newInvalidArraySizeException();
        }
        if (bl2) {
            ReadOnlyHttp2Headers.validateHeaders(asciiStringArray, asciiStringArray2);
        }
        this.pseudoHeaders = asciiStringArray;
        this.otherHeaders = asciiStringArray2;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("pseudoHeaders and otherHeaders must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        int n2;
        for (n2 = 1; n2 < asciiStringArray.length; n2 += 2) {
            if (asciiStringArray[n2] != null) continue;
            throw new IllegalArgumentException("pseudoHeaders value at index " + n2 + " is null");
        }
        n2 = 0;
        int n3 = asciiStringArray2.length - 1;
        for (int i2 = 0; i2 < n3; i2 += 2) {
            AsciiString asciiString = asciiStringArray2[i2];
            DefaultHttp2Headers.HTTP2_NAME_VALIDATOR.validateName(asciiString);
            if (n2 == 0 && !asciiString.isEmpty() && asciiString.byteAt(0) != 58) {
                n2 = 1;
            } else if (n2 != 0 && !asciiString.isEmpty() && asciiString.byteAt(0) == 58) {
                throw new IllegalArgumentException("otherHeaders name at index " + i2 + " is a pseudo header that appears after non-pseudo headers.");
            }
            if (asciiStringArray2[i2 + 1] != null) continue;
            throw new IllegalArgumentException("otherHeaders value at index " + (i2 + 1) + " is null");
        }
    }

    private AsciiString get0(CharSequence charSequence) {
        int n2;
        int n3 = AsciiString.hashCode(charSequence);
        int n4 = this.pseudoHeaders.length - 1;
        for (n2 = 0; n2 < n4; n2 += 2) {
            AsciiString asciiString = this.pseudoHeaders[n2];
            if (asciiString.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.pseudoHeaders[n2 + 1];
        }
        n2 = this.otherHeaders.length - 1;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            AsciiString asciiString = this.otherHeaders[i2];
            if (asciiString.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.otherHeaders[i2 + 1];
        }
        return null;
    }

    @Override
    public CharSequence get(CharSequence charSequence) {
        return this.get0(charSequence);
    }

    @Override
    public CharSequence get(CharSequence charSequence, CharSequence charSequence2) {
        CharSequence charSequence3 = this.get(charSequence);
        return charSequence3 != null ? charSequence3 : charSequence2;
    }

    @Override
    public CharSequence getAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public CharSequence getAndRemove(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public List<CharSequence> getAll(CharSequence charSequence) {
        int n2;
        int n3 = AsciiString.hashCode(charSequence);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n4 = this.pseudoHeaders.length - 1;
        for (n2 = 0; n2 < n4; n2 += 2) {
            AsciiString asciiString = this.pseudoHeaders[n2];
            if (asciiString.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add(this.pseudoHeaders[n2 + 1]);
        }
        n2 = this.otherHeaders.length - 1;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            AsciiString asciiString = this.otherHeaders[i2];
            if (asciiString.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add(this.otherHeaders[i2 + 1]);
        }
        return arrayList;
    }

    @Override
    public List<CharSequence> getAllAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Boolean getBoolean(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Boolean.valueOf(CharSequenceValueConverter.INSTANCE.convertToBoolean(asciiString)) : null;
    }

    @Override
    public boolean getBoolean(CharSequence charSequence, boolean bl2) {
        Boolean bl3 = this.getBoolean(charSequence);
        return bl3 != null ? bl3 : bl2;
    }

    @Override
    public Byte getByte(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Byte.valueOf(CharSequenceValueConverter.INSTANCE.convertToByte(asciiString)) : null;
    }

    @Override
    public byte getByte(CharSequence charSequence, byte by2) {
        Byte by3 = this.getByte(charSequence);
        return by3 != null ? by3 : by2;
    }

    @Override
    public Character getChar(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Character.valueOf(CharSequenceValueConverter.INSTANCE.convertToChar(asciiString)) : null;
    }

    @Override
    public char getChar(CharSequence charSequence, char c2) {
        Character c3 = this.getChar(charSequence);
        return c3 != null ? c3.charValue() : c2;
    }

    @Override
    public Short getShort(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Short.valueOf(CharSequenceValueConverter.INSTANCE.convertToShort(asciiString)) : null;
    }

    @Override
    public short getShort(CharSequence charSequence, short s2) {
        Short s3 = this.getShort(charSequence);
        return s3 != null ? s3 : s2;
    }

    @Override
    public Integer getInt(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Integer.valueOf(CharSequenceValueConverter.INSTANCE.convertToInt(asciiString)) : null;
    }

    @Override
    public int getInt(CharSequence charSequence, int n2) {
        Integer n3 = this.getInt(charSequence);
        return n3 != null ? n3 : n2;
    }

    @Override
    public Long getLong(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToLong(asciiString)) : null;
    }

    @Override
    public long getLong(CharSequence charSequence, long l2) {
        Long l3 = this.getLong(charSequence);
        return l3 != null ? l3 : l2;
    }

    @Override
    public Float getFloat(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Float.valueOf(CharSequenceValueConverter.INSTANCE.convertToFloat(asciiString)) : null;
    }

    @Override
    public float getFloat(CharSequence charSequence, float f2) {
        Float f3 = this.getFloat(charSequence);
        return f3 != null ? f3.floatValue() : f2;
    }

    @Override
    public Double getDouble(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Double.valueOf(CharSequenceValueConverter.INSTANCE.convertToDouble(asciiString)) : null;
    }

    @Override
    public double getDouble(CharSequence charSequence, double d2) {
        Double d3 = this.getDouble(charSequence);
        return d3 != null ? d3 : d2;
    }

    @Override
    public Long getTimeMillis(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToTimeMillis(asciiString)) : null;
    }

    @Override
    public long getTimeMillis(CharSequence charSequence, long l2) {
        Long l3 = this.getTimeMillis(charSequence);
        return l3 != null ? l3 : l2;
    }

    @Override
    public Boolean getBooleanAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean getBooleanAndRemove(CharSequence charSequence, boolean bl2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Byte getByteAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public byte getByteAndRemove(CharSequence charSequence, byte by2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Character getCharAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public char getCharAndRemove(CharSequence charSequence, char c2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Short getShortAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public short getShortAndRemove(CharSequence charSequence, short s2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Integer getIntAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public int getIntAndRemove(CharSequence charSequence, int n2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Long getLongAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public long getLongAndRemove(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Float getFloatAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public float getFloatAndRemove(CharSequence charSequence, float f2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Double getDoubleAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public double getDoubleAndRemove(CharSequence charSequence, double d2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Long getTimeMillisAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public long getTimeMillisAndRemove(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean contains(CharSequence charSequence) {
        return this.get(charSequence) != null;
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return this.contains(charSequence, charSequence2, false);
    }

    @Override
    public boolean containsObject(CharSequence charSequence, Object object) {
        if (object instanceof CharSequence) {
            return this.contains(charSequence, (CharSequence)object);
        }
        return this.contains(charSequence, object.toString());
    }

    @Override
    public boolean containsBoolean(CharSequence charSequence, boolean bl2) {
        return this.contains(charSequence, String.valueOf(bl2));
    }

    @Override
    public boolean containsByte(CharSequence charSequence, byte by2) {
        return this.contains(charSequence, String.valueOf(by2));
    }

    @Override
    public boolean containsChar(CharSequence charSequence, char c2) {
        return this.contains(charSequence, String.valueOf(c2));
    }

    @Override
    public boolean containsShort(CharSequence charSequence, short s2) {
        return this.contains(charSequence, String.valueOf(s2));
    }

    @Override
    public boolean containsInt(CharSequence charSequence, int n2) {
        return this.contains(charSequence, String.valueOf(n2));
    }

    @Override
    public boolean containsLong(CharSequence charSequence, long l2) {
        return this.contains(charSequence, String.valueOf(l2));
    }

    @Override
    public boolean containsFloat(CharSequence charSequence, float f2) {
        return false;
    }

    @Override
    public boolean containsDouble(CharSequence charSequence, double d2) {
        return this.contains(charSequence, String.valueOf(d2));
    }

    @Override
    public boolean containsTimeMillis(CharSequence charSequence, long l2) {
        return this.contains(charSequence, String.valueOf(l2));
    }

    @Override
    public int size() {
        return this.pseudoHeaders.length + this.otherHeaders.length >>> 1;
    }

    @Override
    public boolean isEmpty() {
        return this.pseudoHeaders.length == 0 && this.otherHeaders.length == 0;
    }

    @Override
    public Set<CharSequence> names() {
        int n2;
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<CharSequence> linkedHashSet = new LinkedHashSet<CharSequence>(this.size());
        int n3 = this.pseudoHeaders.length - 1;
        for (n2 = 0; n2 < n3; n2 += 2) {
            linkedHashSet.add(this.pseudoHeaders[n2]);
        }
        n2 = this.otherHeaders.length - 1;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            linkedHashSet.add(this.otherHeaders[i2]);
        }
        return linkedHashSet;
    }

    @Override
    public Http2Headers add(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(CharSequence charSequence, CharSequence ... charSequenceArray) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence charSequence, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence charSequence, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence charSequence, Object ... objectArray) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addBoolean(CharSequence charSequence, boolean bl2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addByte(CharSequence charSequence, byte by2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addChar(CharSequence charSequence, char c2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addShort(CharSequence charSequence, short s2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addInt(CharSequence charSequence, int n2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addLong(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addFloat(CharSequence charSequence, float f2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addDouble(CharSequence charSequence, double d2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addTimeMillis(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence charSequence, CharSequence ... charSequenceArray) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence charSequence, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence charSequence, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence charSequence, Object ... objectArray) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setBoolean(CharSequence charSequence, boolean bl2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setByte(CharSequence charSequence, byte by2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setChar(CharSequence charSequence, char c2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setShort(CharSequence charSequence, short s2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setInt(CharSequence charSequence, int n2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setLong(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setFloat(CharSequence charSequence, float f2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setDouble(CharSequence charSequence, double d2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setTimeMillis(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean remove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers clear() {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyHttp2Headers$ReadOnlyIterator(this, null);
    }

    @Override
    public Iterator<CharSequence> valueIterator(CharSequence charSequence) {
        return new ReadOnlyHttp2Headers$ReadOnlyValueIterator(this, charSequence);
    }

    @Override
    public Http2Headers method(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers scheme(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers authority(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers path(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers status(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public CharSequence method() {
        return this.get(Http2Headers$PseudoHeaderName.METHOD.value());
    }

    @Override
    public CharSequence scheme() {
        return this.get(Http2Headers$PseudoHeaderName.SCHEME.value());
    }

    @Override
    public CharSequence authority() {
        return this.get(Http2Headers$PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public CharSequence path() {
        return this.get(Http2Headers$PseudoHeaderName.PATH.value());
    }

    @Override
    public CharSequence status() {
        return this.get(Http2Headers$PseudoHeaderName.STATUS.value());
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        int n2 = AsciiString.hashCode(charSequence);
        HashingStrategy<CharSequence> hashingStrategy = bl2 ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        int n3 = hashingStrategy.hashCode(charSequence2);
        return ReadOnlyHttp2Headers.contains(charSequence, n2, charSequence2, n3, hashingStrategy, this.otherHeaders) || ReadOnlyHttp2Headers.contains(charSequence, n2, charSequence2, n3, hashingStrategy, this.pseudoHeaders);
    }

    private static boolean contains(CharSequence charSequence, int n2, CharSequence charSequence2, int n3, HashingStrategy<CharSequence> hashingStrategy, AsciiString[] asciiStringArray) {
        int n4 = asciiStringArray.length - 1;
        for (int i2 = 0; i2 < n4; i2 += 2) {
            AsciiString asciiString = asciiStringArray[i2];
            AsciiString asciiString2 = asciiStringArray[i2 + 1];
            if (asciiString.hashCode() != n2 || asciiString2.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence) || !hashingStrategy.equals(asciiString2, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String string = "";
        for (Map.Entry<CharSequence, CharSequence> entry : this) {
            stringBuilder.append(string);
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
            string = ", ";
        }
        return stringBuilder.append(']').toString();
    }

    static /* synthetic */ AsciiString[] access$100(ReadOnlyHttp2Headers readOnlyHttp2Headers) {
        return readOnlyHttp2Headers.pseudoHeaders;
    }

    static /* synthetic */ AsciiString[] access$200(ReadOnlyHttp2Headers readOnlyHttp2Headers) {
        return readOnlyHttp2Headers.otherHeaders;
    }
}

